/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.renderer.tileentity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nightkosh.gravestone.api.grave.EnumGraveType;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.core.Resources;
import nightkosh.gravestone.models.block.ModelGraveStone;
import nightkosh.gravestone.models.block.graves.ModelCatStatueGraveStone;
import nightkosh.gravestone.models.block.graves.ModelCelticCrossGravestone;
import nightkosh.gravestone.models.block.graves.ModelCreeperStatueGravestone;
import nightkosh.gravestone.models.block.graves.ModelCrossGraveStone;
import nightkosh.gravestone.models.block.graves.ModelDogStatueGraveStone;
import nightkosh.gravestone.models.block.graves.ModelHorizontalPlateGraveStone;
import nightkosh.gravestone.models.block.graves.ModelHorseGraveStone;
import nightkosh.gravestone.models.block.graves.ModelObeliskGravestone;
import nightkosh.gravestone.models.block.graves.ModelSkeletonCorpseGravestone;
import nightkosh.gravestone.models.block.graves.ModelVerticalPlateGraveStone;
import nightkosh.gravestone.models.block.graves.ModelVillagerStatueGravestone;
import nightkosh.gravestone.renderer.tileentity.TileEntityRenderer;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityGraveStoneRenderer
extends TileEntityRenderer {
    private static final Map<EnumGraves, ResourceLocation> mossyTexturesMap = Maps.newHashMap();
    public static ModelGraveStone verticalPlate = new ModelVerticalPlateGraveStone();
    public static ModelGraveStone cross = new ModelCrossGraveStone();
    public static ModelGraveStone obelisk = new ModelObeliskGravestone();
    public static ModelGraveStone celticCross = new ModelCelticCrossGravestone();
    public static ModelGraveStone horizontalPlate = new ModelHorizontalPlateGraveStone();
    public static ModelGraveStone villagerStatue = new ModelVillagerStatueGravestone();
    public static ModelGraveStone dogStatue = new ModelDogStatueGraveStone();
    public static ModelGraveStone catStatue = new ModelCatStatueGraveStone();
    public static ModelGraveStone horseStatue = new ModelHorseGraveStone();
    public static ModelGraveStone creeperStatue = new ModelCreeperStatueGravestone();
    public static ModelGraveStone skeletonCorpse = new ModelSkeletonCorpseGravestone(false);
    public static ModelGraveStone witheredSkeletonCorpse = new ModelSkeletonCorpseGravestone(true);
    public static TileEntityGraveStoneRenderer instance;
    private static final TileEntityGraveStone GRAVE_TE;
    private static final ItemStack SWORD;

    public TileEntityGraveStoneRenderer() {
        instance = this;
    }

    @Override
    public void func_180535_a(TileEntity te, double x, double y, double z, float f, int par9) {
        ItemStack sword;
        boolean isEnchanted;
        boolean isSwordGrave;
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)te;
        if (tileEntity == null) {
            tileEntity = this.getDefaultTE();
            isSwordGrave = this.isSwordGrave();
            isEnchanted = false;
            sword = SWORD;
        } else {
            isSwordGrave = tileEntity.isSwordGrave();
            sword = tileEntity.getSword();
            isEnchanted = tileEntity.isEnchanted();
        }
        EnumGraves graveType = tileEntity.getGraveType();
        int meta = 0;
        if (tileEntity.func_145831_w() != null) {
            meta = tileEntity.func_145832_p();
        }
        EnumFacing facing = EnumFacing.values()[meta];
        this.renderGrave(x, y, z, tileEntity.func_145831_w(), graveType, isEnchanted, tileEntity.isMossy(), tileEntity.hasFlower(), tileEntity.getFlower(), isSwordGrave, sword, facing);
    }

    public void renderGrave(double x, double y, double z, World world, EnumGraves graveType, boolean isEnchanted, boolean isMossy, boolean hasFlower, ItemStack flower, boolean isSwordGrave, ItemStack sword, EnumFacing facing) {
        GL11.glPushMatrix();
        if (world == null && isSwordGrave) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 2.0f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.5f, (float)-1.5f, (float)-1.5f);
        } else {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        }
        switch (facing) {
            case SOUTH: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.renderGrave(world, graveType, isEnchanted, isMossy, hasFlower, flower, isSwordGrave, sword);
        GL11.glPopMatrix();
    }

    private void renderGrave(World world, EnumGraves graveType, boolean isEnchanted, boolean isMossy, boolean hasFlower, ItemStack flower, boolean isSwordGrave, ItemStack sword) {
        if (isSwordGrave) {
            this.renderSword(world, sword, isEnchanted);
        } else {
            ModelGraveStone model = this.getModel(graveType.getGraveType());
            this.bindTextureByName(this.getTexture(graveType, graveType.getTexture(), isMossy));
            if (graveType.getGraveType() == EnumGraveType.CREEPER_STATUE) {
                model.customRender(isEnchanted);
            } else if (isEnchanted) {
                model.renderEnchanted();
            } else {
                model.renderAll();
            }
            if (hasFlower) {
                this.renderFlower(world, flower);
            }
        }
    }

    private ResourceLocation getTexture(EnumGraves graveType, ResourceLocation texture, boolean isMossy) {
        if (isMossy) {
            ResourceLocation mixedMossyTexture = mossyTexturesMap.get(graveType);
            if (mixedMossyTexture == null) {
                ResourceLocation mossyTexture = this.getMossyTexture(graveType.getGraveType());
                mixedMossyTexture = new ResourceLocation(texture.func_110624_b() + ":mossy_" + texture.func_110623_a());
                Minecraft.func_71410_x().func_110434_K().func_110579_a(mixedMossyTexture, (ITextureObject)new LayeredTexture(new String[]{texture.func_110624_b() + ":" + texture.func_110623_a(), mossyTexture.func_110624_b() + ":" + mossyTexture.func_110623_a()}));
                mossyTexturesMap.put(graveType, mixedMossyTexture);
                return mixedMossyTexture;
            }
            return mixedMossyTexture;
        }
        return texture;
    }

    private ResourceLocation getMossyTexture(EnumGraveType graveType) {
        switch (graveType) {
            default: {
                return Resources.GRAVE_MOSSY_VERTICAL_PLATE;
            }
            case CROSS: {
                return Resources.GRAVE_MOSSY_CROSS;
            }
            case OBELISK: {
                return Resources.MOSSY_OBELISK;
            }
            case CELTIC_CROSS: {
                return Resources.MOSSY_CELTIC_CROSS;
            }
            case HORIZONTAL_PLATE: {
                return Resources.GRAVE_MOSSY_HORISONTAL_PLATE;
            }
            case VILLAGER_STATUE: {
                return Resources.MOSSY_VILLAGER_STATUE;
            }
            case DOG_STATUE: {
                return Resources.MOSSY_DOG_STATUE;
            }
            case CAT_STATUE: {
                return Resources.MOSSY_CAT_STATUE;
            }
            case HORSE_STATUE: {
                return Resources.GRAVE_MOSSY_HORSE_STATUE;
            }
            case CREEPER_STATUE: 
        }
        return Resources.MOSSY_CREEPER_STATUE;
    }

    private ModelGraveStone getModel(EnumGraveType graveType) {
        switch (graveType) {
            default: {
                return verticalPlate;
            }
            case CROSS: {
                return cross;
            }
            case OBELISK: {
                return obelisk;
            }
            case CELTIC_CROSS: {
                return celticCross;
            }
            case HORIZONTAL_PLATE: {
                return horizontalPlate;
            }
            case VILLAGER_STATUE: {
                return villagerStatue;
            }
            case DOG_STATUE: {
                return dogStatue;
            }
            case CAT_STATUE: {
                return catStatue;
            }
            case HORSE_STATUE: {
                return horseStatue;
            }
            case CREEPER_STATUE: {
                return creeperStatue;
            }
            case STARVED_CORPSE: {
                return skeletonCorpse;
            }
            case WITHERED_CORPSE: 
        }
        return witheredSkeletonCorpse;
    }

    private void renderSword(World world, ItemStack sword, boolean isEnchanted) {
        if (isEnchanted && !sword.func_77948_v()) {
            if (!sword.func_77942_o()) {
                sword.func_77982_d(new NBTTagCompound());
            }
            sword.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        EntityItem entityitem = new EntityItem(world, 0.0, 0.0, 0.0, sword);
        entityitem.field_70290_d = 0.0f;
        GL11.glTranslatef((float)-0.37f, (float)0.83f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)-1.5f, (float)-1.5f);
        GL11.glRotatef((float)225.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Minecraft.func_71410_x().func_175598_ae().func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    private void renderFlower(World world, ItemStack flower) {
        EntityItem entityitem = new EntityItem(world, 0.0, 0.0, 0.0, flower);
        entityitem.field_70290_d = 0.0f;
        GL11.glTranslatef((float)0.0f, (float)1.6f, (float)-0.1f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    protected TileEntityGraveStone getDefaultTE() {
        return GRAVE_TE;
    }

    protected boolean isSwordGrave() {
        return false;
    }

    static {
        GRAVE_TE = new TileEntityGraveStone();
        SWORD = new ItemStack(Items.field_151040_l);
        GRAVE_TE.setGraveType(EnumGraves.STONE_VERTICAL_PLATE.ordinal());
    }

    public static class SwordRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        @Override
        protected boolean isSwordGrave() {
            return true;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.SWORD.ordinal());
        }
    }

    public static class WitheredCorpseRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.WITHERED_CORPSE.ordinal());
        }
    }

    public static class StarvedCorpseRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STARVED_CORPSE.ordinal());
        }
    }

    public static class CreeperStatueRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_CREEPER_STATUE.ordinal());
        }
    }

    public static class HorseStatueRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_HORSE_STATUE.ordinal());
        }
    }

    public static class CatStatueRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_CAT_STATUE.ordinal());
        }
    }

    public static class DogStatueRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_DOG_STATUE.ordinal());
        }
    }

    public static class VillagerStatueRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_VILLAGER_STATUE.ordinal());
        }
    }

    public static class HorizontalPlateRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_HORIZONTAL_PLATE.ordinal());
        }
    }

    public static class CelticCrossRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_CELTIC_CROSS.ordinal());
        }
    }

    public static class ObeliskRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_OBELISK.ordinal());
        }
    }

    public static class CrossRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_CROSS.ordinal());
        }
    }

    public static class VerticalPlateRenderer
    extends TileEntityGraveStoneRenderer {
        private static final TileEntityGraveStone GRAVE_TE = new TileEntityGraveStone();

        @Override
        protected TileEntityGraveStone getDefaultTE() {
            return GRAVE_TE;
        }

        static {
            GRAVE_TE.setGraveType(EnumGraves.STONE_VERTICAL_PLATE.ordinal());
        }
    }
}

