/*
 * Decompiled with CFR 0.152.
 */
package staircraftmod.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BTBlockDirt
extends Block {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", DirtType.class);
    public static final PropertyBool SNOWY = PropertyBool.func_177716_a((String)"snowy");
    private static final String __OBFID = "CL_00000228";

    public BTBlockDirt() {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)DirtType.DIRT)).func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b((IProperty)VARIANT) == DirtType.PODZOL) {
            Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
            state = state.func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(block == Blocks.field_150433_aE || block == Blocks.field_150431_aC));
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        list.add(new ItemStack((Block)this, 1, DirtType.DIRT.getMetadata()));
        list.add(new ItemStack((Block)this, 1, DirtType.COARSE_DIRT.getMetadata()));
        list.add(new ItemStack((Block)this, 1, DirtType.PODZOL.getMetadata()));
    }

    public int func_176222_j(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        return iblockstate.func_177230_c() != this ? 0 : ((DirtType)((Object)iblockstate.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)DirtType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((DirtType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT, SNOWY});
    }

    public int func_180651_a(IBlockState state) {
        DirtType dirttype = (DirtType)((Object)state.func_177229_b((IProperty)VARIANT));
        if (dirttype == DirtType.PODZOL) {
            dirttype = DirtType.DIRT;
        }
        return dirttype.getMetadata();
    }

    public static enum DirtType implements IStringSerializable
    {
        DIRT(0, "dirt", "default"),
        COARSE_DIRT(1, "coarse_dirt", "coarse"),
        PODZOL(2, "podzol");

        private static final DirtType[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final String unlocalizedName;
        private static final String __OBFID = "CL_00002125";

        private DirtType(int metadata, String name) {
            this(metadata, name, name);
        }

        private DirtType(int metadata, String name, String unlocalizedName) {
            this.metadata = metadata;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public String toString() {
            return this.name;
        }

        public static DirtType byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            METADATA_LOOKUP = new DirtType[DirtType.values().length];
            DirtType[] var0 = DirtType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                DirtType var3;
                DirtType.METADATA_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

