/*
 * Decompiled with CFR 0.152.
 */
package slabcraftmod.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slabcraftmod.api.BlockSC1API;

public abstract class BlockLeavesSlab
extends BlockSlab
implements IShearable {
    public static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockLeavesSlab() {
        super(Material.field_151584_j);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_180632_j(iblockstate.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.OAK)));
        this.func_149713_g(1);
    }

    public boolean func_149662_c() {
        return this.func_176552_j();
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.func_149662_c()) {
            return false;
        }
        BlockSlab.EnumBlockHalf side = (BlockSlab.EnumBlockHalf)world.func_180495_p(pos).func_177229_b((IProperty)field_176554_a);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180644_h(state);
        }
        EnumType enumtype = (EnumType)((Object)state.func_177229_b((IProperty)VARIANT));
        return enumtype == EnumType.OAK ? ColorizerFoliage.func_77468_c() : (enumtype == EnumType.SPRUCE ? ColorizerFoliage.func_77466_a() : (enumtype == EnumType.BIRCH ? ColorizerFoliage.func_77469_b() : (enumtype == EnumType.JUNGLE ? ColorizerFoliage.func_77468_c() : (enumtype == EnumType.ACACIA ? ColorizerFoliage.func_77468_c() : (enumtype == EnumType.DARKOAK ? ColorizerFoliage.func_77468_c() : super.func_180644_h(state))))));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == this) {
            EnumType enumtype = (EnumType)((Object)iblockstate.func_177229_b((IProperty)VARIANT));
            if (enumtype == EnumType.OAK) {
                return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
            }
            if (enumtype == EnumType.SPRUCE) {
                return ColorizerFoliage.func_77466_a();
            }
            if (enumtype == EnumType.BIRCH) {
                return ColorizerFoliage.func_77469_b();
            }
            if (enumtype == EnumType.JUNGLE) {
                return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
            }
            if (enumtype == EnumType.ACACIA) {
                return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
            }
            if (enumtype == EnumType.DARKOAK) {
                return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
            }
        }
        return super.func_180662_a(worldIn, pos, renderPass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_175727_C(pos.func_177984_a()) && !World.func_175683_a((IBlockAccess)worldIn, (BlockPos)pos.func_177977_b()) && rand.nextInt(15) == 1) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)VARIANT));
        if (type == EnumType.ACACIA) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.ACACIA.getMetadata()));
        }
        if (type == EnumType.BIRCH) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.BIRCH.getMetadata()));
        }
        if (type == EnumType.DARKOAK) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.DARKOAK.getMetadata()));
        }
        if (type == EnumType.JUNGLE) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.JUNGLE.getMetadata()));
        }
        if (type == EnumType.OAK) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.OAK.getMetadata()));
        }
        if (type == EnumType.SPRUCE) {
            ret.add(new ItemStack(BlockSC1API.leaves_single, this.func_176552_j() ? 2 : 1, EnumType.SPRUCE.getMetadata()));
        }
        return ret;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(worldIn, pos, worldIn.func_180495_p(pos), player) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_180643_i(state);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack stack : items) {
                BlockLeavesSlab.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
        }
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getUnlocalizedName();
    }

    public IProperty func_176551_l() {
        return VARIANT;
    }

    public Object func_176553_a(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        if (itemIn != Item.func_150898_a((Block)BlockSC1API.leaves_double)) {
            for (EnumType enumtype : EnumType.values()) {
                list.add(new ItemStack(itemIn, 1, enumtype.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                i |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockState func_180661_e() {
        return this.func_176552_j() ? new BlockState((Block)this, new IProperty[]{SEAMLESS, VARIANT}) : new BlockState((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        OAK(0, "leaves_oak_slab"),
        SPRUCE(1, "leaves_spruce_slab"),
        BIRCH(2, "leaves_birch_slab"),
        JUNGLE(3, "leaves_jungle_slab"),
        ACACIA(4, "leaves_acacia_slab"),
        DARKOAK(5, "leaves_dark_oak_slab");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] var0 = EnumType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                EnumType var3;
                EnumType.META_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

