/*
 * Decompiled with CFR 0.152.
 */
package wallcraftmod.blocks;

import flowercraftmod.api.BlockFCAPI;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wallcraftmod.ModWallcraft;
import wallcraftmod.api.BlockWCAPI;

public class BlockWCLavaWall
extends Block {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockWCLavaWall(Block modelBlock, Material material) {
        super(Material.field_151587_i);
        this.func_149675_a(true);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(ModWallcraft.tabWC);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        return 0xFFFFFF;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    protected boolean isSurroundingBlockFlammable(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.getCanBlockBurn(worldIn, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(World worldIn, BlockPos p_176368_2_) {
        return worldIn.func_180495_p(p_176368_2_).func_177230_c().func_149688_o().func_76217_h();
    }

    public boolean canPlaceTorchOnTop(IBlockAccess world, BlockPos pos) {
        if (this.isSideSolid(world, pos, EnumFacing.UP)) {
            return true;
        }
        return this == BlockWCAPI.WCLavaWall;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        if (this.field_149764_J == Material.field_151587_i && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151579_a && !worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_149662_c()) {
            if (rand.nextInt(100) == 0) {
                double d8 = d0 + (double)rand.nextFloat();
                double d4 = d1 + this.field_149756_F;
                double d6 = d2 + (double)rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_72980_b(d8, d4, d6, "liquid.lavapop", 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                worldIn.func_72980_b(d0, d1, d2, "liquid.lava", 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        if (rand.nextInt(10) == 0 && World.func_175683_a((IBlockAccess)worldIn, (BlockPos)pos.func_177977_b())) {
            super.func_180655_c(worldIn, pos, state, rand);
            Material material = worldIn.func_180495_p(pos.func_177979_c(2)).func_177230_c().func_149688_o();
            if (!material.func_76230_c() && !material.func_76224_d()) {
                double d3 = d0 + (double)rand.nextFloat();
                double d5 = d1 - 1.05;
                double d7 = d2 + (double)rand.nextFloat();
                if (this.field_149764_J == Material.field_151587_i) {
                    worldIn.func_175688_a(EnumParticleTypes.DRIP_LAVA, d3, d5, d7, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        block5: {
            if (this.field_149764_J != Material.field_151587_i || !worldIn.func_82736_K().func_82766_b("doFireTick")) break block5;
            int i = rand.nextInt(3);
            if (i > 0) {
                BlockPos blockpos1 = pos;
                for (int j = 0; j < i; ++j) {
                    Block block = worldIn.func_180495_p(blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, 1, rand.nextInt(3) - 1)).func_177230_c();
                    if (block.func_149688_o() == Material.field_151579_a) {
                        if (!this.isSurroundingBlockFlammable(worldIn, blockpos1)) continue;
                        worldIn.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
                        return;
                    }
                    if (!this.field_149764_J.func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos2 = pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1);
                    if (!worldIn.func_175623_d(blockpos2.func_177984_a()) || !this.getCanBlockBurn(worldIn, blockpos2)) continue;
                    worldIn.func_175656_a(blockpos2.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.SOLID;
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        boolean flag = this.canConnectTo(worldIn, pos.func_177978_c());
        boolean flag1 = this.canConnectTo(worldIn, pos.func_177968_d());
        boolean flag2 = this.canConnectTo(worldIn, pos.func_177976_e());
        boolean flag3 = this.canConnectTo(worldIn, pos.func_177974_f());
        float f = 0.25f;
        float f1 = 0.75f;
        float f2 = 0.25f;
        float f3 = 0.75f;
        float f4 = 1.0f;
        if (flag) {
            f2 = 0.0f;
        }
        if (flag1) {
            f3 = 1.0f;
        }
        if (flag2) {
            f = 0.0f;
        }
        if (flag3) {
            f1 = 1.0f;
        }
        if (flag && flag1 && !flag2 && !flag3) {
            f4 = 0.8125f;
            f = 0.3125f;
            f1 = 0.6875f;
        } else if (!flag && !flag1 && flag2 && flag3) {
            f4 = 0.8125f;
            f2 = 0.3125f;
            f3 = 0.6875f;
        }
        this.func_149676_a(f, 0.0f, f2, f1, f4, f3);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        this.field_149756_F = 1.5;
        return super.func_180640_a(worldIn, pos, state);
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        IBlockState blockState = worldIn.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == BlockWCAPI.WCWoolWall || block == BlockWCAPI.WCStainedGlassWall || block == BlockWCAPI.WCStainedClayWall || block == BlockWCAPI.WCStoneWall || block == BlockWCAPI.WCStone1Wall || block == BlockWCAPI.WCStone2Wall || block == BlockWCAPI.WCStone3Wall || block == BlockWCAPI.WCGrassWall || block == BlockWCAPI.WCDirtWall || block == BlockWCAPI.WCMyceliumWall || block == BlockWCAPI.WCGravelWall || block == BlockWCAPI.WCSandWall || block == BlockWCAPI.WCLavaWall || block == BlockWCAPI.WCIceWall || block == BlockWCAPI.WCIcePackedWall || block == BlockWCAPI.WCSnowWall || block == BlockWCAPI.WCGlowstoneWall || block == BlockWCAPI.WCGlassWall || block == BlockWCAPI.WCMushroomWall || block == BlockWCAPI.WCLogWall || block == BlockWCAPI.WCPlanksWall || block == BlockWCAPI.WCLeavesWall || block == BlockWCAPI.WCOreIronWall || block == BlockWCAPI.WCOreDiamondWall || block == BlockWCAPI.WCOreEmeraldWall || block == BlockWCAPI.WCOreGoldWall || block == BlockWCAPI.WCOreObsidianWall || block == BlockWCAPI.WCOreLapisWall || block == BlockWCAPI.WCOreRedstoneWall || block == BlockWCAPI.WCOreCoalBlock || block == BlockWCAPI.WCNetherrackWall || block == BlockWCAPI.WCHayWall || block == BlockWCAPI.WCEndStone || block == BlockWCAPI.WCSlimeWall || block == BlockWCAPI.WCSeaLatern || block == BlockWCAPI.WCSoulSand || block == BlockWCAPI.WCHardClayWall || block == BlockFCAPI.FCHedgeWall || block == BlockFCAPI.FCPetalWall || block == BlockFCAPI.FCHedgeThornWall) {
            return true;
        }
        if (block.func_149688_o().func_76218_k() && block.func_149686_d()) {
            return block.func_149688_o() != Material.field_151572_C;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? super.func_176225_a(worldIn, pos, side) : true;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(!worldIn.func_175623_d(pos.func_177984_a()))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177976_e())));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{UP, NORTH, EAST, WEST, SOUTH});
    }
}

