/*
 * Decompiled with CFR 0.152.
 */
package com.zulucap.sheeeps.entities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SheeepsEntityList {
    private static final Logger logger = LogManager.getLogger();
    public static final Map<String, Class<? extends Entity>> stringToClassMapping = Maps.newHashMap();
    public static final Map<Class<? extends Entity>, String> classToStringMapping = Maps.newHashMap();
    public static final Map<Integer, Class<? extends Entity>> idToClassMapping = Maps.newHashMap();
    private static final Map<Class<? extends Entity>, Integer> classToIDMapping = Maps.newHashMap();
    private static final Map<String, Integer> stringToIDMapping = Maps.newHashMap();
    public static final Map<Integer, EntityEggInfo> entityEggs = Maps.newLinkedHashMap();

    public static void addMapping(Class<? extends Entity> entityClass, String entityName, int id) {
        if (id < 0 || id > 255) {
            throw new IllegalArgumentException("Attempted to register a entity with invalid ID: " + id + " Name: " + entityName + " Class: " + entityClass);
        }
        if (stringToClassMapping.containsKey(entityName)) {
            throw new IllegalArgumentException("ID is already registered: " + entityName);
        }
        if (idToClassMapping.containsKey(id)) {
            throw new IllegalArgumentException("ID is already registered: " + id);
        }
        if (id == 0) {
            throw new IllegalArgumentException("Cannot register to reserved id: " + id);
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("Cannot register null clazz for id: " + id);
        }
        stringToClassMapping.put(entityName, entityClass);
        classToStringMapping.put(entityClass, entityName);
        idToClassMapping.put(id, entityClass);
        classToIDMapping.put(entityClass, id);
        stringToIDMapping.put(entityName, id);
    }

    public static void addMapping(Class<? extends Entity> entityClass, String entityName, int entityID, int baseColor, int spotColor) {
        SheeepsEntityList.addMapping(entityClass, entityName, entityID);
    }

    public static Entity createEntityByName(String entityName, World worldIn) {
        Entity entity = null;
        try {
            Class<? extends Entity> oclass = stringToClassMapping.get(entityName);
            if (oclass != null) {
                entity = oclass.getConstructor(World.class).newInstance(worldIn);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound nbt, World worldIn) {
        Entity entity = null;
        if ("Minecart".equals(nbt.func_74779_i("id"))) {
            nbt.func_74778_a("id", EntityMinecart.EnumMinecartType.func_180038_a((int)nbt.func_74762_e("Type")).func_180040_b());
            nbt.func_82580_o("Type");
        }
        Class<? extends Entity> oclass = null;
        try {
            oclass = stringToClassMapping.get(nbt.func_74779_i("id"));
            if (oclass != null) {
                entity = oclass.getConstructor(World.class).newInstance(worldIn);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            try {
                entity.func_70020_e(nbt);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An Entity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{nbt.func_74779_i("id"), oclass.getName()});
                entity = null;
            }
        } else {
            logger.warn("Skipping Entity with id " + nbt.func_74779_i("id"));
        }
        return entity;
    }

    public static Entity createEntityByID(int entityID, World worldIn) {
        Entity entity = null;
        try {
            Class<? extends Entity> oclass = SheeepsEntityList.getClassFromID(entityID);
            if (oclass != null) {
                entity = oclass.getConstructor(World.class).newInstance(worldIn);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            logger.warn("Skipping Entity with id " + entityID);
        }
        return entity;
    }

    public static int getEntityID(Entity entityIn) {
        Integer integer = classToIDMapping.get(entityIn.getClass());
        return integer == null ? 0 : integer;
    }

    public static Class<? extends Entity> getClassFromID(int entityID) {
        return idToClassMapping.get(entityID);
    }

    public static String getEntityString(Entity entityIn) {
        return classToStringMapping.get(entityIn.getClass());
    }

    public static String getStringFromID(int entityID) {
        return classToStringMapping.get(SheeepsEntityList.getClassFromID(entityID));
    }

    @SideOnly(value=Side.CLIENT)
    public static int getIDFromString(String entityName) {
        Integer integer = stringToIDMapping.get(entityName);
        return integer == null ? 90 : integer;
    }

    public static void func_151514_a() {
    }

    public static List<String> getEntityNameList() {
        Set<String> set = stringToClassMapping.keySet();
        ArrayList list = Lists.newArrayList();
        for (String s : set) {
            Class<? extends Entity> oclass = stringToClassMapping.get(s);
            if ((oclass.getModifiers() & 0x400) == 1024) continue;
            list.add(s);
        }
        list.add("LightningBolt");
        return list;
    }

    public static boolean isStringEntityName(Entity entityIn, String entityName) {
        String s = SheeepsEntityList.getEntityString(entityIn);
        if (s == null && entityIn instanceof EntityPlayer) {
            s = "Player";
        } else if (s == null && entityIn instanceof EntityLightningBolt) {
            s = "LightningBolt";
        }
        return entityName.equals(s);
    }

    public static boolean isStringValidEntityName(String entityName) {
        return "Player".equals(entityName) || SheeepsEntityList.getEntityNameList().contains(entityName);
    }

    public static class EntityEggInfo {
        @Deprecated
        public final int spawnedID;
        public final String name;
        public final int primaryColor;
        public final int secondaryColor;
        public final StatBase field_151512_d;
        public final StatBase field_151513_e;

        public EntityEggInfo(String name, int primaryColor, int secondaryColor) {
            this.spawnedID = -1;
            this.name = name;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
            this.field_151512_d = new StatBase("stat.killEntity." + name, (IChatComponent)new ChatComponentTranslation("stat.entityKill", new Object[]{new ChatComponentTranslation("entity." + name + ".name", new Object[0])})).func_75971_g();
            this.field_151513_e = new StatBase("stat.entityKilledBy." + name, (IChatComponent)new ChatComponentTranslation("stat.entityKilledBy", new Object[]{new ChatComponentTranslation("entity." + name + ".name", new Object[0])})).func_75971_g();
        }
    }
}

