/*
 * Decompiled with CFR 0.152.
 */
package com.zulucap.sheeeps.items;

import com.google.common.collect.Maps;
import com.zulucap.sheeeps.init.SheeepsBlocks;
import com.zulucap.sheeeps.init.SheeepsItems;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class WasherRegistry {
    private static final WasherRegistry washerBase = new WasherRegistry();
    private Map<ItemStack, ItemStack> washingList = Maps.newHashMap();

    public static WasherRegistry instance() {
        return washerBase;
    }

    public WasherRegistry() {
        this.addWasherRecipeForItem(SheeepsItems.coal_fleece, new ItemStack(SheeepsBlocks.coal_wool));
        this.addWasherRecipeForItem(SheeepsItems.iron_fleece, new ItemStack(SheeepsBlocks.iron_wool));
        this.addWasherRecipeForItem(SheeepsItems.diamond_fleece, new ItemStack(SheeepsBlocks.diamond_wool));
        this.addWasherRecipeForItem(SheeepsItems.emerald_fleece, new ItemStack(SheeepsBlocks.emerald_wool));
        this.addWasherRecipeForItem(SheeepsItems.gold_fleece, new ItemStack(SheeepsBlocks.gold_wool));
        this.addWasherRecipeForItem(SheeepsItems.glowstone_fleece, new ItemStack(SheeepsBlocks.glowstone_wool));
        this.addWasherRecipeForItem(SheeepsItems.redstone_fleece, new ItemStack(SheeepsBlocks.redstone_wool));
        this.addWasherRecipeForItem(SheeepsItems.lapis_fleece, new ItemStack(SheeepsBlocks.lapis_wool));
    }

    public void addWasherRecipeForItem(Item input, ItemStack stack) {
        this.addWashing(input, stack);
    }

    public void addWashing(Item input, ItemStack stack) {
        this.addWashingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack);
    }

    public void addWashingRecipe(ItemStack input, ItemStack stack) {
        if (this.getWashingResult(input) != null) {
            FMLLog.info((String)("Ignored washing recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        this.washingList.put(input, stack);
    }

    public ItemStack getWashingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.washingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().func_77946_l();
        }
        return null;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }
}

