/*
 * Decompiled with CFR 0.152.
 */
package com.zulucap.sheeeps.entities;

import com.zulucap.sheeeps.entities.SheeepsEntity;
import com.zulucap.sheeeps.init.SheeepsEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class EntityOreSheep
extends EntitySheep {
    public static final int TYPE_ID = 19;
    public static final String TYPE_NBT = "Type";

    public EntityOreSheep(World worldIn) {
        super(worldIn);
    }

    public ResourceLocation getShearedTexture() {
        SheeepsEntity sheeep = this.getSheeep();
        return sheeep.getShearedTexture();
    }

    public ResourceLocation getFurTexture() {
        SheeepsEntity sheeep = this.getSheeep();
        return sheeep.getFurTexture();
    }

    public void setSheeepType(int type) {
        this.field_70180_af.func_75692_b(19, (Object)type);
    }

    private SheeepsEntity getSheeep() {
        return SheeepsEntities.getByType(this.getSheeepType());
    }

    private int getSheeepType() {
        return this.field_70180_af.func_75679_c(19);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public boolean func_70601_bi() {
        return true;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingData) {
        if ((livingData = super.func_180482_a(difficulty, livingData)) instanceof GroupData) {
            GroupData groupData = (GroupData)livingData;
            this.setSheeepType(groupData.getType());
        } else {
            BlockPos pos;
            BiomeGenBase biome = this.field_70170_p.func_180494_b(this.func_180425_c());
            List<SheeepsEntity> possibleSheeeps = SheeepsEntities.getPossibleSheeeps(biome, pos = this.func_180425_c());
            if (possibleSheeeps.size() == 0) {
                possibleSheeeps.add(SheeepsEntities.getByType(2));
            }
            SheeepsEntity sheeep = possibleSheeeps.get(this.field_70146_Z.nextInt(possibleSheeeps.size()));
            int type = sheeep.getId();
            this.setSheeepType(type);
            livingData = new GroupData(type);
        }
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        return livingData;
    }

    public void func_70109_d(NBTTagCompound tagCompund) {
        super.func_70109_d(tagCompund);
        tagCompund.func_74768_a(TYPE_NBT, this.getSheeepType());
    }

    public void func_70020_e(NBTTagCompound tagCompund) {
        super.func_70020_e(tagCompund);
        this.setSheeepType(tagCompund.func_74762_e(TYPE_NBT));
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        SheeepsEntity sheeep = this.getSheeep();
        return sheeep.getEntityName();
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int i;
        if (!this.func_70892_o()) {
            i = this.field_70146_Z.nextInt(2) + 1;
            ItemStack fleece = this.getFleeceDropItem();
            fleece.field_77994_a = i;
            this.func_70099_a(fleece, 0.0f);
        }
        i = this.field_70146_Z.nextInt(2) + 1 + this.field_70146_Z.nextInt(1 + p_70628_2_);
        for (int j = 0; j < i; ++j) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_179557_bn, 1);
                continue;
            }
            this.func_145779_a(Items.field_179561_bm, 1);
        }
    }

    protected Item func_146068_u() {
        SheeepsEntity sheeep = this.getSheeep();
        return sheeep.getDropItem().func_77973_b();
    }

    protected ItemStack getFleeceDropItem() {
        SheeepsEntity sheeep = this.getSheeep();
        ItemStack dropItem = sheeep.getDropItem();
        dropItem.field_77994_a = 1;
        return dropItem;
    }

    public boolean func_70085_c(EntityPlayer player) {
        return super.func_70085_c(player);
    }

    public EntitySheep func_90011_a(EntityAgeable ageable) {
        EntitySheep entitysheep = (EntitySheep)ageable;
        EntitySheep entitysheep1 = new EntitySheep(this.field_70170_p);
        return entitysheep1;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.func_70893_e(true);
        int i = 1 + this.field_70146_Z.nextInt(2);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(this.getFleeceDropItem());
        }
        this.func_85030_a("mob.sheep.shear", 1.0f, 1.0f);
        return ret;
    }

    private static class GroupData
    implements IEntityLivingData {
        private final int type;

        public GroupData(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

