/*
 * Decompiled with CFR 0.152.
 */
package com.zulucap.sheeeps.gui;

import com.zulucap.sheeeps.gui.SheeepsGuiBase;
import com.zulucap.sheeeps.inventory.ContainerSeparator;
import com.zulucap.sheeeps.tileentities.TileEntitySeparator;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public class GuiSeparator
extends SheeepsGuiBase {
    private final TileEntitySeparator te;
    private final ResourceLocation guiTexture;
    final int COOK_BAR_XPOS = 80;
    final int COOK_BAR_YPOS = 34;
    final int COOK_BAR_ICON_U = 176;
    final int COOK_BAR_ICON_V = 14;
    final int COOK_BAR_WIDTH = 24;
    final int COOK_BAR_HEIGHT = 17;
    final int FLAME_XPOS = -9;
    final int FLAME_YPOS = 37;
    final int FLAME_ICON_U = 176;
    final int FLAME_ICON_V = 0;
    final int FLAME_WIDTH = 14;
    final int FLAME_HEIGHT = 14;
    final int FLAME_X_SPACING = 18;

    public GuiSeparator(InventoryPlayer playerInventory, String guiTextureName, TileEntitySeparator te) {
        super(new ContainerSeparator(playerInventory, te), "separator", (IInventory)te);
        this.guiTexture = new ResourceLocation("sheeeps:textures/gui/" + guiTextureName + ".png");
        this.te = te;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    @Override
    protected void func_146976_a(float partialTicks, int x, int y) {
        super.func_146976_a(partialTicks, x, y);
        double cookProgress = this.te.fractionOfCookTimeComplete();
        this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 34, 176, 14, (int)(cookProgress * 24.0), 17);
        double burnRemaining = this.te.fractionOfFuelRemaining();
        int yOffset = (int)((1.0 - burnRemaining) * 14.0);
        this.func_73729_b(this.field_147003_i + -9 + 18, this.field_147009_r + 37 + yOffset, 176, 0 + yOffset, 14, 14 - yOffset);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int LABEL_XPOS = 5;
        int LABEL_YPOS = 5;
        ArrayList<String> hoveringText = new ArrayList<String>();
        if (GuiSeparator.isInRect(this.field_147003_i + 80, this.field_147009_r + 34, 24, 17, mouseX, mouseY)) {
            hoveringText.add("Progress:");
            int cookPercentage = (int)(this.te.fractionOfCookTimeComplete() * 100.0);
            hoveringText.add(cookPercentage + "%");
        }
        if (GuiSeparator.isInRect(this.field_147003_i + -9 + 18, this.field_147009_r + 37, 14, 14, mouseX, mouseY)) {
            hoveringText.add("Fuel Time:");
            hoveringText.add(this.te.secondsOfFuelRemaining() + "s");
        }
        if (!hoveringText.isEmpty()) {
            this.drawHoveringText(hoveringText, mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_146289_q);
        }
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }
}

