/*
 * Decompiled with CFR 0.152.
 */
package com.zulucap.sheeeps.init;

import com.zulucap.sheeeps.configuration.ConfigurationReference;
import com.zulucap.sheeeps.configuration.SheepConfig;
import com.zulucap.sheeeps.entities.SheeepsEntity;
import com.zulucap.sheeeps.init.SheeepsItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;

public class SheeepsEntities {
    private static final Map<Integer, SheeepsEntity> sheeeps = new HashMap<Integer, SheeepsEntity>();
    private static int modEntityID = 0;

    public static void register(SheeepsEntity entity) {
        sheeeps.put(entity.getId(), entity);
    }

    public static SheeepsEntity getByType(int type) {
        return sheeeps.get(type);
    }

    public static Collection<SheeepsEntity> getItems() {
        return sheeeps.values();
    }

    public static void registerRenders() {
    }

    public static void registerSheeep() {
        SheepConfig emeraldConfig;
        SheepConfig diamondConfig;
        SheepConfig glowstoneConfig;
        SheepConfig lapisConfig;
        SheepConfig redstoneConfig;
        SheepConfig goldConfig;
        SheepConfig ironConfig;
        List<SheepConfig> configuredSheep = ConfigurationReference.getConfiguredSheep();
        SheepConfig coalConfig = configuredSheep.get(0);
        if (!coalConfig.getSheepDisabled()) {
            SheeepsEntity coalOreSheeep = new SheeepsEntity(0, "Coal Ore Sheeep", new ItemStack(SheeepsItems.coal_fleece, 1), new ResourceLocation("sheeeps:textures/entity/coal_ore_sheep_sheared.png"), new ResourceLocation("sheeeps:textures/entity/coal_ore_sheep_fur.png"), coalConfig.getMaxSpawnHeight(), coalConfig.getMinSpawnHeight(), coalConfig.getRarity(), null, new BiomeGenBase[]{BiomeGenBase.field_76778_j});
            SheeepsEntities.register(coalOreSheeep);
        }
        if (!(ironConfig = configuredSheep.get(1)).getSheepDisabled()) {
            SheeepsEntity ironOreSheeep = new SheeepsEntity(1, "Iron Ore Sheeep", new ItemStack(SheeepsItems.iron_fleece, 1), new ResourceLocation("sheeeps:textures/entity/iron_ore_sheep_sheared.png"), new ResourceLocation("sheeeps:textures/entity/iron_ore_sheep_fur.png"), ironConfig.getMaxSpawnHeight(), ironConfig.getMinSpawnHeight(), ironConfig.getRarity(), null, new BiomeGenBase[]{BiomeGenBase.field_76778_j});
            SheeepsEntities.register(ironOreSheeep);
        }
        if (!(goldConfig = configuredSheep.get(2)).getSheepDisabled()) {
            SheeepsEntity goldOreSheeep = new SheeepsEntity(2, "Gold Ore Sheeep", new ItemStack(SheeepsItems.gold_fleece, 1), new ResourceLocation("sheeeps:textures/entity/gold_ore_sheep_sheared.png"), new ResourceLocation("sheeeps:textures/entity/gold_ore_sheep_fur.png"), goldConfig.getMaxSpawnHeight(), goldConfig.getMinSpawnHeight(), goldConfig.getRarity(), null, new BiomeGenBase[]{BiomeGenBase.field_76778_j});
            SheeepsEntities.register(goldOreSheeep);
        }
        if (!(redstoneConfig = configuredSheep.get(3)).getSheepDisabled()) {
            SheeepsEntity redstoneOreSheeep = new SheeepsEntity(3, "Redstone Ore Sheeep", new ItemStack(SheeepsItems.redstone_fleece, 1), new ResourceLocation("sheeeps:textures/entity/redstone_ore_sheep_sheared.png"), new ResourceLocation("sheeeps:textures/entity/redstone_ore_sheep_fur.png"), redstoneConfig.getMaxSpawnHeight(), redstoneConfig.getMinSpawnHeight(), redstoneConfig.getRarity(), null, new BiomeGenBase[]{BiomeGenBase.field_76778_j});
            SheeepsEntities.register(redstoneOreSheeep);
        }
        if (!(lapisConfig = configuredSheep.get(4)).getSheepDisabled()) {
            SheeepsEntity lapisOreSheeep = new SheeepsEntity(4, "Lapis Ore Sheeep", new ItemStack(SheeepsItems.lapis_fleece, 1), new ResourceLocation("sheeeps:textures/entity/lapis_ore_sheep_sheared.png"), new ResourceLocation("sheeeps:textures/entity/lapis_ore_sheep_fur.png"), lapisConfig.getMaxSpawnHeight(), lapisConfig.getMinSpawnHeight(), lapisConfig.getRarity(), null, new BiomeGenBase[]{BiomeGenBase.field_76778_j});
            SheeepsEntities.register(lapisOreSheeep);
        }
        if (!(glowstoneConfig = configuredSheep.get(5)).getSheepDisabled()) {
            SheeepsEntity glowstoneOreSheeep = new SheeepsEntity(5, "Glowstone Ore Sheeep", new ItemStack(SheeepsItems.glowstone_fleece, 1), new ResourceLocation("sheeeps:textures/entity/glowstone_ore_sheep_sheared.png"), new ResourceLocation("sheeeps:textures/entity/glowstone_ore_sheep_fur.png"), glowstoneConfig.getMaxSpawnHeight(), glowstoneConfig.getMinSpawnHeight(), glowstoneConfig.getRarity(), new BiomeGenBase[]{BiomeGenBase.field_76778_j}, null);
            SheeepsEntities.register(glowstoneOreSheeep);
        }
        if (!(diamondConfig = configuredSheep.get(6)).getSheepDisabled()) {
            SheeepsEntity diamondOreSheeep = new SheeepsEntity(6, "Diamond Ore Sheeep", new ItemStack(SheeepsItems.diamond_fleece, 1), new ResourceLocation("sheeeps:textures/entity/diamond_ore_sheep_sheared.png"), new ResourceLocation("sheeeps:textures/entity/diamond_ore_sheep_fur.png"), diamondConfig.getMaxSpawnHeight(), diamondConfig.getMinSpawnHeight(), diamondConfig.getRarity(), null, new BiomeGenBase[]{BiomeGenBase.field_76778_j});
            SheeepsEntities.register(diamondOreSheeep);
        }
        if (!(emeraldConfig = configuredSheep.get(7)).getSheepDisabled()) {
            SheeepsEntity emeraldOreSheeep = new SheeepsEntity(7, "Emerald Ore Sheeep", new ItemStack(SheeepsItems.emerald_fleece, 1), new ResourceLocation("sheeeps:textures/entity/emerald_ore_sheep_sheared.png"), new ResourceLocation("sheeeps:textures/entity/emerald_ore_sheep_fur.png"), emeraldConfig.getMaxSpawnHeight(), emeraldConfig.getMinSpawnHeight(), emeraldConfig.getRarity(), new BiomeGenBase[]{BiomeGenBase.field_76770_e, BiomeGenBase.field_76783_v, BiomeGenBase.field_150580_W}, new BiomeGenBase[]{BiomeGenBase.field_76778_j});
            SheeepsEntities.register(emeraldOreSheeep);
        }
    }

    public static List<SheeepsEntity> getPossibleSheeeps(BiomeGenBase biome, BlockPos pos) {
        ArrayList<SheeepsEntity> result = new ArrayList<SheeepsEntity>();
        int y = pos.func_177956_o();
        for (SheeepsEntity sheeep : SheeepsEntities.getItems()) {
            BiomeGenBase[] spawnBiomes = sheeep.getSpawnBiomes();
            BiomeGenBase[] excludedBiomes = sheeep.getExcludedBiomes();
            if (sheeep.getMaxSpawnHeight() < y || sheeep.getMinSpawnHeight() > y) continue;
            boolean validSpawn = false;
            if (spawnBiomes != null && spawnBiomes.length > 0) {
                for (BiomeGenBase spawnBiome : spawnBiomes) {
                    if (spawnBiome != biome) continue;
                    validSpawn = true;
                }
            } else {
                validSpawn = true;
            }
            if (excludedBiomes != null && excludedBiomes.length > 0) {
                for (BiomeGenBase excludedBiome : excludedBiomes) {
                    if (excludedBiome != biome) continue;
                    validSpawn = false;
                }
            }
            if (!validSpawn || !(Math.random() + (double)sheeep.getRarity() >= 1.0)) continue;
            result.add(sheeep);
        }
        return result;
    }
}

