/*
 * Decompiled with CFR 0.152.
 */
package com.zulucap.sheeeps.items;

import com.google.common.collect.Maps;
import com.zulucap.sheeeps.init.SheeepsBlocks;
import com.zulucap.sheeeps.init.SheeepsItems;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class SeparatorRegistry {
    private static final SeparatorRegistry separatorBase = new SeparatorRegistry();
    private Map<ItemStack, ItemStack> separatingList = Maps.newHashMap();
    private Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static SeparatorRegistry instance() {
        return separatorBase;
    }

    public SeparatorRegistry() {
        this.addSeparatorRecipeForBlock(SheeepsBlocks.coal_wool, new ItemStack(SheeepsItems.coal_residue), 0.5f);
        this.addSeparatorRecipeForBlock(SheeepsBlocks.iron_wool, new ItemStack(SheeepsItems.iron_residue), 0.7f);
        this.addSeparatorRecipeForBlock(SheeepsBlocks.diamond_wool, new ItemStack(SheeepsItems.diamond_residue), 1.0f);
        this.addSeparatorRecipeForBlock(SheeepsBlocks.emerald_wool, new ItemStack(SheeepsItems.emerald_residue), 1.0f);
        this.addSeparatorRecipeForBlock(SheeepsBlocks.gold_wool, new ItemStack(SheeepsItems.gold_residue), 0.7f);
        this.addSeparatorRecipeForBlock(SheeepsBlocks.glowstone_wool, new ItemStack(SheeepsItems.glowstone_residue), 0.85f);
        this.addSeparatorRecipeForBlock(SheeepsBlocks.redstone_wool, new ItemStack(SheeepsItems.redstone_residue), 0.85f);
        this.addSeparatorRecipeForBlock(SheeepsBlocks.lapis_wool, new ItemStack(SheeepsItems.lapis_residue), 0.9f);
    }

    public void addSeparatorRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addSeparating(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addSeparating(Item input, ItemStack stack, float experience) {
        this.addSeparatingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addSeparatingRecipe(ItemStack input, ItemStack stack, float experience) {
        if (this.getSeparatingResult(input) != null) {
            FMLLog.info((String)("Ignored separating recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        this.separatingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSeparatingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.separatingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }
}

