/*
 * Decompiled with CFR 0.152.
 */
package com.zulucap.sheeeps.tileentities;

import com.zulucap.sheeeps.blocks.BaseOreWool;
import com.zulucap.sheeeps.blocks.Separator;
import com.zulucap.sheeeps.items.SeparatorRegistry;
import com.zulucap.sheeeps.tileentities.SheeepsTileEntityBase;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;

public class TileEntitySeparator
extends SheeepsTileEntityBase
implements ITickable,
ISidedInventory {
    private int burnTimeRemaining = 0;
    private int burnTimeInitialValue = 0;
    private short cookTime;
    private static final short COOK_TIME_FOR_COMPLETION = 200;
    private boolean cachedIsBurning = false;
    private int cachedState = 0;
    private int FUEL_SLOT_ID = 0;
    private int WOOL_SLOT_ID = 1;
    private int WOOL_OUTPUT_SLOT_ID = 2;
    private int RESIDUE_OUTPUT_SLOT_ID = 3;
    private static final byte COOK_FIELD_ID = 0;
    private static final byte FIRST_BURN_TIME_REMAINING_FIELD_ID = 1;
    private static final byte FIRST_BURN_TIME_INITIAL_FIELD_ID = 2;
    private String customName;
    private ItemStack[] separatorStacks = new ItemStack[4];

    public void func_73660_a() {
        boolean isBurning = this.burnFuel();
        if (this.canSeparate()) {
            this.cookTime = isBurning ? (short)(this.cookTime + 1) : (short)(this.cookTime - 2);
            if (this.cookTime < 0) {
                this.cookTime = 0;
            }
            if (this.cookTime >= 200) {
                this.separateItem();
                this.cookTime = 0;
            }
        } else {
            this.cookTime = 0;
            this.cachedIsBurning = false;
        }
        if (this.cachedIsBurning != isBurning) {
            this.cachedIsBurning = true;
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (this.burnTimeRemaining > 0) {
            if (this.burnTimeRemaining % 5 < 3) {
                this.setState(1);
            } else {
                this.setState(2);
            }
        } else {
            this.setState(0);
        }
    }

    public void setState(int state) {
        if (this.cachedState != state) {
            this.cachedState = state;
            Separator separator = (Separator)this.func_145838_q();
            Separator.setState(state, this.field_145850_b, this.field_174879_c);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    public double fractionOfFuelRemaining() {
        if (this.burnTimeInitialValue <= 0) {
            return 0.0;
        }
        double fraction = (double)this.burnTimeRemaining / (double)this.burnTimeInitialValue;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    public int secondsOfFuelRemaining() {
        if (this.burnTimeRemaining <= 0) {
            return 0;
        }
        return this.burnTimeRemaining / 20;
    }

    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / 200.0;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    public boolean burnFuel() {
        boolean isBurning = false;
        boolean inventoryChanged = false;
        if (this.burnTimeRemaining > 0) {
            --this.burnTimeRemaining;
            isBurning = true;
        }
        if (this.burnTimeRemaining == 0 && this.canSeparate() && TileEntitySeparator.getItemBurnTime(this.separatorStacks[this.FUEL_SLOT_ID]) > 0) {
            short s = TileEntitySeparator.getItemBurnTime(this.separatorStacks[this.FUEL_SLOT_ID]);
            this.burnTimeInitialValue = s;
            this.burnTimeRemaining = s;
            --this.separatorStacks[this.FUEL_SLOT_ID].field_77994_a;
            isBurning = true;
            inventoryChanged = true;
            if (this.separatorStacks[this.FUEL_SLOT_ID].field_77994_a == 0) {
                this.separatorStacks[this.FUEL_SLOT_ID] = null;
            }
        }
        if (inventoryChanged) {
            this.func_70296_d();
        }
        return isBurning;
    }

    public boolean isFuelBurning() {
        return this.separatorStacks[this.FUEL_SLOT_ID] != null && this.separatorStacks[this.FUEL_SLOT_ID].field_77994_a > 0 && this.canSeparate();
    }

    public static short getItemBurnTime(ItemStack stack) {
        int burntime = TileEntityFurnace.func_145952_a((ItemStack)stack);
        return (short)MathHelper.func_76125_a((int)burntime, (int)0, (int)Short.MAX_VALUE);
    }

    public boolean canSeparate() {
        if (this.separatorStacks[this.WOOL_SLOT_ID] != null && this.separatorStacks[this.WOOL_SLOT_ID].field_77994_a > 0 && (this.separatorStacks[this.WOOL_OUTPUT_SLOT_ID] == null || this.separatorStacks[this.WOOL_OUTPUT_SLOT_ID].field_77994_a < 64)) {
            if (this.separatorStacks[this.RESIDUE_OUTPUT_SLOT_ID] == null) {
                return true;
            }
            if (this.separatorStacks[this.RESIDUE_OUTPUT_SLOT_ID].field_77994_a < 64) {
                ItemStack result = this.getSeparatorResultForItem(this.separatorStacks[this.WOOL_SLOT_ID]);
                return result.func_77973_b() == this.separatorStacks[this.RESIDUE_OUTPUT_SLOT_ID].func_77973_b();
            }
        }
        return false;
    }

    public boolean separateItem() {
        ItemStack result = null;
        if (this.separatorStacks[this.WOOL_SLOT_ID] != null) {
            ItemStack wool = new ItemStack(Blocks.field_150325_L, 1);
            result = this.getSeparatorResultForItem(this.separatorStacks[this.WOOL_SLOT_ID]);
            ItemStack outputWoolStack = this.separatorStacks[this.WOOL_OUTPUT_SLOT_ID];
            ItemStack outputResidueStack = this.separatorStacks[this.RESIDUE_OUTPUT_SLOT_ID];
            if (outputWoolStack == null || outputWoolStack.field_77994_a < this.func_70297_j_()) {
                if (result != null && (outputResidueStack == null || outputResidueStack.field_77994_a < this.func_70297_j_())) {
                    if (this.separatorStacks[this.RESIDUE_OUTPUT_SLOT_ID] == null) {
                        this.separatorStacks[this.RESIDUE_OUTPUT_SLOT_ID] = result.func_77946_l();
                    } else {
                        this.separatorStacks[this.RESIDUE_OUTPUT_SLOT_ID].field_77994_a += result.field_77994_a;
                    }
                }
                if (this.separatorStacks[this.WOOL_OUTPUT_SLOT_ID] == null) {
                    this.separatorStacks[this.WOOL_OUTPUT_SLOT_ID] = wool.func_77946_l();
                } else {
                    this.separatorStacks[this.WOOL_OUTPUT_SLOT_ID].field_77994_a += wool.field_77994_a;
                }
                --this.separatorStacks[this.WOOL_SLOT_ID].field_77994_a;
                if (this.separatorStacks[this.WOOL_SLOT_ID].field_77994_a == 0) {
                    this.separatorStacks[this.WOOL_SLOT_ID] = null;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public ItemStack getSeparatorResultForItem(ItemStack stack) {
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
            return null;
        }
        return SeparatorRegistry.instance().getSeparatingResult(stack);
    }

    public int func_70302_i_() {
        return this.separatorStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.separatorStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.separatorStacks[index] != null) {
            if (this.separatorStacks[index].field_77994_a <= count) {
                ItemStack itemstack = this.separatorStacks[index];
                this.func_70299_a(index, null);
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.separatorStacks[index].func_77979_a(count);
            if (this.separatorStacks[index].field_77994_a == 0) {
                this.func_70299_a(index, null);
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.separatorStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) != this ? false : player.func_174818_b(new BlockPos((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                if (TileEntitySeparator.getItemBurnTime(stack) <= 0) break;
                return true;
            }
            case 1: {
                if (!(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BaseOreWool)) break;
                return true;
            }
        }
        return false;
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.cookTime;
        }
        if (id == 1) {
            return this.burnTimeRemaining;
        }
        if (id == 2) {
            return this.burnTimeInitialValue;
        }
        System.err.println("Invalid field ID in TileInventorySmelting.setField:" + id);
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.cookTime = (short)value;
        } else if (id == 1) {
            this.burnTimeRemaining = value;
        } else if (id == 2) {
            this.burnTimeInitialValue = value;
        } else {
            System.err.println("Invalid field ID in TileInventorySmelting.setField:" + id);
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "Separator";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        boolean METADATA = false;
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145841_b(NBTTagCompound parentNBTTagCompound) {
        super.func_145841_b(parentNBTTagCompound);
        NBTTagList dataForAllSlots = new NBTTagList();
        for (int i = 0; i < this.separatorStacks.length; ++i) {
            if (this.separatorStacks[i] == null) continue;
            NBTTagCompound dataForThisSlot = new NBTTagCompound();
            dataForThisSlot.func_74774_a("Slot", (byte)i);
            this.separatorStacks[i].func_77955_b(dataForThisSlot);
            dataForAllSlots.func_74742_a((NBTBase)dataForThisSlot);
        }
        parentNBTTagCompound.func_74782_a("Items", (NBTBase)dataForAllSlots);
        parentNBTTagCompound.func_74777_a("CookTime", this.cookTime);
        parentNBTTagCompound.func_74782_a("burnTimeRemaining", (NBTBase)new NBTTagInt(this.burnTimeRemaining));
        parentNBTTagCompound.func_74782_a("burnTimeInitial", (NBTBase)new NBTTagInt(this.burnTimeInitialValue));
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        int NBT_TYPE_COMPOUND = 10;
        NBTTagList dataForAllSlots = nbtTagCompound.func_150295_c("Items", 10);
        Arrays.fill(this.separatorStacks, null);
        for (int i = 0; i < dataForAllSlots.func_74745_c(); ++i) {
            NBTTagCompound dataForOneSlot = dataForAllSlots.func_150305_b(i);
            byte slotNumber = dataForOneSlot.func_74771_c("Slot");
            if (slotNumber < 0 || slotNumber >= this.separatorStacks.length) continue;
            this.separatorStacks[slotNumber] = ItemStack.func_77949_a((NBTTagCompound)dataForOneSlot);
        }
        this.cookTime = nbtTagCompound.func_74765_d("CookTime");
        this.burnTimeRemaining = nbtTagCompound.func_74762_e("burnTimeRemaining");
        this.burnTimeInitialValue = nbtTagCompound.func_74762_e("burnTimeInitial");
    }
}

