/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.GenerationHandler;
import jaredbgreat.dldungeons.builder.Builder;
import jaredbgreat.dldungeons.themes.ThemeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import net.minecraft.world.World;

public class ReadAPI {
    public static void spawnDungeon(World world, int chunkX, int chunkZ) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        try {
            Builder.placeDungeon(new Random(), chunkX, chunkZ, world);
        }
        catch (Throwable e) {
            System.err.println("[DLDUNGEONS] Danger!  Failed to finalize a dungeon after building!");
            e.printStackTrace();
        }
    }

    public static void spawnDungeon(World world, int chunkX, int chunkZ, long seed) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        try {
            Builder.placeDungeon(new Random(seed), chunkX, chunkZ, world);
        }
        catch (Throwable e) {
            System.err.println("[DLDUNGEONS] Danger!  Failed to finalize a dungeon after building!");
            e.printStackTrace();
        }
    }

    public static void spawnDungeon(World world, int chunkX, int chunkZ, Random random) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        try {
            Builder.placeDungeon(random, chunkX, chunkZ, world);
        }
        catch (Throwable e) {
            System.err.println("[DLDUNGEONS] Danger!  Failed to finalize a dungeon after building!");
            e.printStackTrace();
        }
    }

    public static void addDimension(byte dim) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        GenerationHandler.addDimension(dim);
    }

    public static void subDimension(int dim) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        GenerationHandler.subDimension(dim);
    }

    public static void setDimensions(int[] dims) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        GenerationHandler.setDimensions(dims);
    }

    public static void setDifficulty(int diff) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        ConfigHandler.parseDiff(diff);
    }

    public static void loadTheme(String file) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        File theme = new File(file);
        BufferedReader instream = null;
        try {
            instream = new BufferedReader(new FileReader(ConfigHandler.configDir.toString() + File.separator + file.toString()));
            System.out.println("[DLDUNGEONS] Loading theme file " + file.toString());
            ThemeReader.parseTheme(instream, file.toString());
            if (instream != null) {
                instream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void blacklistDimensions() {
        if (ConfigHandler.disableAPI) {
            return;
        }
        ConfigHandler.positiveDims = false;
    }

    public static void whitelistDimensions() {
        if (ConfigHandler.disableAPI) {
            return;
        }
        ConfigHandler.positiveDims = true;
    }

    public static void saveWorldData(World world) {
        if (ConfigHandler.disableAPI) {
            return;
        }
        String saveDir = world.func_72860_G().func_75760_g();
    }

    public static void reloadConfig() {
        if (ConfigHandler.disableAPI) {
            return;
        }
        ConfigHandler.reload();
    }

    public static boolean apiOn() {
        return !ConfigHandler.disableAPI;
    }
}

