/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.builder;

import jaredbgreat.dldungeons.DoomlikeDungeons;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.planner.Dungeon;
import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class Builder {
    private static boolean debugPole = false;

    public static void placeDungeon(Random random, int chunkX, int chunkZ, World world) throws Throwable {
        if (world.field_72995_K) {
            return;
        }
        DoomlikeDungeons.profiler.startTask("Create Dungeons");
        Dungeon dungeon = new Dungeon(random, world.func_180494_b(new BlockPos(chunkX * 16, 64, chunkZ * 16)), world, chunkX, chunkZ);
        System.out.println("[DLDUNGONS] Running Builder.buildDungeon; building dungeon");
        Builder.buildDungeon(dungeon);
        System.out.println("[DLDUNGONS] Dungeon should be built now!");
        dungeon.preFinalize();
        dungeon = null;
        DoomlikeDungeons.profiler.endTask("Create Dungeons");
    }

    public static void placeDungeon(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) throws Throwable {
        if (world.field_72995_K) {
            return;
        }
        DoomlikeDungeons.profiler.startTask("Create Dungeons");
        Dungeon dungeon = new Dungeon(random, world.func_180494_b(new BlockPos(chunkX * 16, 64, chunkZ * 16)), world, chunkX, chunkZ);
        System.out.println("[DLDUNGONS] Running Builder.buildDungeon; building dungeon");
        if (dungeon.theme != null) {
            if (debugPole) {
                Builder.debuggingPole(world, chunkX, chunkZ, dungeon);
            }
            Builder.buildDungeon(dungeon);
            System.out.println("[DLDUNGONS] Dungeon should be built now!");
        }
        dungeon.preFinalize();
        dungeon = null;
        DoomlikeDungeons.profiler.endTask("Create Dungeons");
    }

    public static void buildDungeon(Dungeon dungeon) {
        if (dungeon.theme != null) {
            dungeon.map.build(dungeon);
        }
    }

    public static void debuggingPole(World world, int chunkX, int chunkZ, Dungeon dungeon) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int y = -16; y <= 241; ++y) {
            DBlock.placeBlock(world, x, y, z, DBlock.quartz);
        }
        for (int i = -dungeon.size.radius; i <= dungeon.size.radius; ++i) {
            DBlock.placeBlock(world, x - dungeon.size.radius, 80, z + i, DBlock.lapis);
            DBlock.placeBlock(world, x + dungeon.size.radius, 80, z + i, DBlock.lapis);
            DBlock.placeBlock(world, x + i, 80, z - dungeon.size.radius, DBlock.lapis);
            DBlock.placeBlock(world, x + i, 80, z + dungeon.size.radius, DBlock.lapis);
        }
    }

    public static void setDebugPole(boolean val) {
        debugPole = val;
    }
}

