/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.builder;

import jaredbgreat.dldungeons.debug.Logging;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class DBlock {
    private final String id;
    private final Block block;
    private final int meta;
    public static final Block spawner = Blocks.field_150474_ac;
    public static final Block chest = Blocks.field_150486_ae;
    public static final Block portal1 = Blocks.field_150378_br;
    public static final Block portal2 = Blocks.field_150384_bq;
    public static final Block quartz = Blocks.field_150371_ca;
    public static final Block lapis = Blocks.field_150368_y;
    public static final Block water = Blocks.field_150355_j;
    public static final Block air = Blocks.field_150350_a;
    public static final int chestid = Block.func_149682_b((Block)chest);
    public static final int spawnerid = Block.func_149682_b((Block)spawner);
    public static final int portal1id = Block.func_149682_b((Block)portal1);
    public static final int portal2id = Block.func_149682_b((Block)portal2);
    public static final ArrayList<DBlock> registry = new ArrayList();

    private DBlock(String id) {
        this.id = id;
        StringTokenizer nums = new StringTokenizer(id, "({[]})");
        this.block = Block.func_149684_b((String)nums.nextToken());
        if (this.block == null) {
            Logging.LogError("[DLDUNGEONS] ERROR! Block read as \"" + id + "\" was was not in registry (returned null).");
        }
        this.meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
    }

    private DBlock(String id, float version) throws NoSuchElementException {
        String error;
        StringTokenizer nums;
        this.id = id;
        if ((double)version < 1.7) {
            nums = new StringTokenizer(id, "({[]})");
            this.block = Block.func_149684_b((String)nums.nextToken());
            this.meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
        } else {
            nums = new StringTokenizer(id, ":({[]})");
            String modid = nums.nextToken();
            if (modid.toLowerCase().equals("minecraft") || modid.toLowerCase().equals("vanilla")) {
                this.block = Block.func_149684_b((String)nums.nextToken());
                this.meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
            } else {
                this.block = Block.func_149634_a((Item)GameRegistry.findItem((String)modid, (String)nums.nextToken()));
                this.meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
            }
        }
        if (this.block == null) {
            error = "[DLDUNGEONS] ERROR! Block read as \"" + id + "\" was was not in registry (returned null).";
            Logging.LogError(error);
            throw new NoSuchElementException(error);
        }
        if (this.block == null) {
            error = "[DLDUNGEONS] ERROR! Block read as \"" + id + "\" was was not in registry (returned null).";
            Logging.LogError(error);
            throw new NoSuchElementException(error);
        }
    }

    public void placeNoMeta(World world, int x, int y, int z) {
        System.out.println(this.block);
        if (!DBlock.isProtectedBlock(world, x, y, z)) {
            world.func_175656_a(new BlockPos(x, y, z), this.block.func_176223_P());
        }
    }

    public void place(World world, int x, int y, int z) {
        if (!DBlock.isProtectedBlock(world, x, y, z)) {
            world.func_175656_a(new BlockPos(x, y, z), this.block.func_176203_a(this.meta));
        }
    }

    public static void place(World world, int x, int y, int z, int block) {
        if (!DBlock.isProtectedBlock(world, x, y, z)) {
            registry.get(block).place(world, x, y, z);
        }
    }

    public static int add(String id) {
        DBlock block = new DBlock(id);
        if (!registry.contains(block)) {
            registry.add(block);
        }
        return registry.indexOf(block);
    }

    public static int add(String id, float version) throws NoSuchElementException {
        DBlock block = new DBlock(id, version);
        if (!registry.contains(block)) {
            registry.add(block);
        }
        return registry.indexOf(block);
    }

    public static void placeBlock(World world, int x, int y, int z, Block block) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_175656_a(new BlockPos(x, y, z), block.func_176223_P());
    }

    public static void placeBlock(World world, int x, int y, int z, Block block, int a, int b) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_175656_a(new BlockPos(x, y, z), block.func_176203_a(a));
    }

    public static void deleteBlock(World world, int x, int y, int z) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_175698_g(new BlockPos(x, y, z));
    }

    public static void deleteBlock(World world, int x, int y, int z, boolean flooded) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        if (flooded) {
            DBlock.placeBlock(world, x, y, z, water);
        } else {
            world.func_175698_g(new BlockPos(x, y, z));
        }
    }

    public static void placeChest(World world, int x, int y, int z) {
        DBlock.placeBlock(world, x, y, z, chest);
    }

    public static void placeSpawner(World world, int x, int y, int z, String mob) {
        BlockPos pos = new BlockPos(x, y, z);
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        DBlock.placeBlock(world, x, y, z, spawner);
        TileEntityMobSpawner theSpawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        MobSpawnerBaseLogic logic = theSpawner.func_145881_a();
        logic.func_98272_a(mob);
    }

    public static boolean isGroundBlock(World world, int x, int y, int z) {
        Material mat = world.func_72964_e(x / 16, z / 16).func_177438_a(x, y, z).func_149688_o();
        return mat == Material.field_151577_b || mat == Material.field_151573_f || mat == Material.field_151578_c || mat == Material.field_151595_p || mat == Material.field_151576_e || mat == Material.field_151571_B || mat == Material.field_151589_v;
    }

    public static boolean isProtectedBlock(World world, int x, int y, int z) {
        int block = Block.func_149682_b((Block)world.func_180495_p(new BlockPos(x, y, z)).func_177230_c());
        return block == chestid || block == spawnerid || block == portal1id || block == portal2id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DBlock)) {
            return false;
        }
        return this.id.hashCode() == ((DBlock)other).id.hashCode();
    }

    public int hashCode() {
        int a = Block.func_149682_b((Block)this.block);
        a = (a << 4) + this.meta;
        a += a << 16;
        return a;
    }
}

