/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import jaredbgreat.dldungeons.pieces.chests.LootType;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class BasicChest {
    public int mx;
    public int my;
    public int mz;
    public int level;

    public BasicChest(int x, int y, int z, int level) {
        this.mx = x;
        this.my = y;
        this.mz = z;
        this.level = level;
    }

    public void place(World world, int x, int y, int z, Random random) {
        BlockPos pos = new BlockPos(x, y, z);
        this.level += random.nextInt(2);
        if (this.level >= 7) {
            this.level = 6;
        }
        if (world.func_180495_p(pos).func_177230_c() != DBlock.chest) {
            System.err.println("[DLDUNGEONS] ERROR! Trying to put loot into non-chest at " + x + ", " + y + ", " + z + " (basic chest).");
            return;
        }
        TileEntityChest contents = (TileEntityChest)world.func_175625_s(pos);
        if (this.addVanillaLoot(random)) {
            this.vanillaChest(contents, random);
        }
        int which = random.nextInt(3);
        switch (which) {
            case 0: {
                this.fillChest(contents, LootType.HEAL, random);
                break;
            }
            case 1: {
                this.fillChest(contents, LootType.GEAR, random);
                break;
            }
            case 2: {
                this.fillChest(contents, LootType.RANDOM, random);
            }
        }
    }

    private void vanillaChest(TileEntityChest chest, Random random) {
        ChestGenHooks chinf;
        int which = random.nextInt(6);
        switch (which) {
            case 0: {
                chinf = ChestGenHooks.getInfo((String)"bonusChest");
                break;
            }
            case 1: {
                chinf = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
                break;
            }
            case 2: {
                chinf = ChestGenHooks.getInfo((String)"pyramidJungleChest");
                break;
            }
            case 3: {
                chinf = ChestGenHooks.getInfo((String)"mineshaftCorridor");
                break;
            }
            case 4: {
                chinf = ChestGenHooks.getInfo((String)"villageBlacksmith");
                break;
            }
            default: {
                chinf = ChestGenHooks.getInfo((String)"dungeonChest");
            }
        }
        WeightedRandomChestContent.func_177630_a((Random)random, (List)chinf.getItems(random), (IInventory)chest, (int)chinf.getCount(random));
    }

    protected void fillChest(TileEntityChest chest, LootType kind, Random random) {
        ItemStack treasure;
        int num = ConfigHandler.stingyLoot ? random.nextInt(2 + this.level / 2) + 1 : random.nextInt(3 + this.level / 2) + 2;
        for (int i = 0; i < num; ++i) {
            ItemStack treasure2 = LootCategory.getLoot(kind, this.level, random).getStack(random);
            if (treasure2 == null) continue;
            chest.func_70299_a(random.nextInt(27), treasure2);
        }
        if (!ConfigHandler.vanillaLoot && (treasure = LootCategory.getLoot(LootType.HEAL, this.level, random).getStack(random)) != null) {
            chest.func_70299_a(random.nextInt(27), treasure);
        }
    }

    protected boolean addVanillaLoot(Random random) {
        boolean out = ConfigHandler.stingyLoot ? random.nextInt(21) < this.level * 2 : random.nextInt(14) < this.level + 7;
        return out && ConfigHandler.vanillaLoot;
    }
}

