/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.pieces.chests.LootItem;
import jaredbgreat.dldungeons.pieces.chests.LootList;
import jaredbgreat.dldungeons.pieces.chests.LootType;
import java.util.Random;

public class LootCategory {
    public static final int LEVELS = 7;
    public LootList[] levels = new LootList[7];
    public static LootCategory gear = new LootCategory(new LootList[]{LootList.gear1, LootList.gear2, LootList.gear3, LootList.gear4, LootList.gear5, LootList.gear6, LootList.gear7});
    public static LootCategory heal = new LootCategory(new LootList[]{LootList.heal1, LootList.heal2, LootList.heal3, LootList.heal4, LootList.heal5, LootList.heal6, LootList.heal7});
    public static LootCategory loot = new LootCategory(new LootList[]{LootList.loot1, LootList.loot2, LootList.loot3, LootList.loot4, LootList.loot5, LootList.loot6, LootList.loot7});

    public LootCategory(LootList[] loots) {
        this.levels = loots;
    }

    public static LootItem getLoot(LootType type, int level, Random random) {
        level += random.nextInt(2);
        if ((level -= random.nextInt(2)) < 0) {
            level = 0;
        }
        switch (type) {
            case GEAR: {
                if (level > 6) {
                    level = 6;
                }
                return LootCategory.gear.levels[level].getLoot(random);
            }
            case HEAL: {
                if (level > 6) {
                    level = 6;
                }
                return LootCategory.heal.levels[level].getLoot(random);
            }
            case LOOT: {
                if (level > 6) {
                    if (random.nextBoolean()) {
                        return LootList.special.getLoot(random);
                    }
                    level = 6;
                }
                return LootCategory.loot.levels[level].getLoot(random);
            }
        }
        switch (random.nextInt(3)) {
            case 0: {
                return LootCategory.getLoot(LootType.GEAR, level, random);
            }
            case 1: {
                return LootCategory.getLoot(LootType.HEAL, level, random);
            }
        }
        return LootCategory.getLoot(LootType.LOOT, level, random);
    }
}

