/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.entrances;

import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.pieces.entrances.AbstractEntrance;
import jaredbgreat.dldungeons.planner.Dungeon;
import net.minecraft.world.World;

public class SpiralStair
extends AbstractEntrance {
    public SpiralStair(int x, int y, int z) {
        super(x, y, z);
    }

    @Override
    public void build(Dungeon dungeon, World world) {
        int wx = this.x + dungeon.map.chunkX * 16 - dungeon.map.room.length / 2 + 8;
        int wz = this.z + dungeon.map.chunkZ * 16 - dungeon.map.room.length / 2 + 8;
        int bottom = dungeon.map.floorY[this.x][this.z];
        int top = world.func_72940_L();
        while (!DBlock.isGroundBlock(world, wx, top, wz)) {
            --top;
        }
        ++top;
        int side = dungeon.random.nextInt(4);
        for (int i = bottom; i < top; ++i) {
            DBlock.place(world, wx, i, wz, dungeon.wallBlock1);
            switch (side) {
                case 0: {
                    DBlock.placeBlock(world, wx + 1, i, wz, stairSlab, 0, 3);
                    DBlock.placeBlock(world, wx + 1, i, wz + 1, stairSlab, 8, 3);
                    DBlock.deleteBlock(world, wx, i, wz + 1);
                    DBlock.deleteBlock(world, wx - 1, i, wz + 1);
                    DBlock.deleteBlock(world, wx - 1, i, wz);
                    DBlock.deleteBlock(world, wx - 1, i, wz - 1);
                    DBlock.deleteBlock(world, wx, i, wz - 1);
                    DBlock.deleteBlock(world, wx + 1, i, wz - 1);
                    break;
                }
                case 1: {
                    DBlock.placeBlock(world, wx, i, wz + 1, stairSlab, 0, 3);
                    DBlock.placeBlock(world, wx - 1, i, wz + 1, stairSlab, 8, 3);
                    DBlock.deleteBlock(world, wx + 1, i, wz);
                    DBlock.deleteBlock(world, wx + 1, i, wz + 1);
                    DBlock.deleteBlock(world, wx - 1, i, wz);
                    DBlock.deleteBlock(world, wx - 1, i, wz - 1);
                    DBlock.deleteBlock(world, wx, i, wz - 1);
                    DBlock.deleteBlock(world, wx + 1, i, wz - 1);
                    break;
                }
                case 2: {
                    DBlock.placeBlock(world, wx - 1, i, wz, stairSlab, 0, 3);
                    DBlock.placeBlock(world, wx - 1, i, wz - 1, stairSlab, 8, 3);
                    DBlock.deleteBlock(world, wx + 1, i, wz);
                    DBlock.deleteBlock(world, wx + 1, i, wz + 1);
                    DBlock.deleteBlock(world, wx, i, wz + 1);
                    DBlock.deleteBlock(world, wx - 1, i, wz + 1);
                    DBlock.deleteBlock(world, wx, i, wz - 1);
                    DBlock.deleteBlock(world, wx + 1, i, wz - 1);
                    break;
                }
                case 3: {
                    DBlock.placeBlock(world, wx, i, wz - 1, stairSlab, 0, 3);
                    DBlock.placeBlock(world, wx + 1, i, wz - 1, stairSlab, 8, 3);
                    DBlock.deleteBlock(world, wx + 1, i, wz);
                    DBlock.deleteBlock(world, wx + 1, i, wz + 1);
                    DBlock.deleteBlock(world, wx, i, wz + 1);
                    DBlock.deleteBlock(world, wx - 1, i, wz + 1);
                    DBlock.deleteBlock(world, wx - 1, i, wz);
                    DBlock.deleteBlock(world, wx - 1, i, wz - 1);
                }
            }
            side = (side + 1) % 4;
        }
    }
}

