/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.DoomlikeDungeons;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.pieces.Spawner;
import jaredbgreat.dldungeons.pieces.chests.BasicChest;
import jaredbgreat.dldungeons.pieces.entrances.SimpleEntrance;
import jaredbgreat.dldungeons.pieces.entrances.SpiralStair;
import jaredbgreat.dldungeons.pieces.entrances.TopRoom;
import jaredbgreat.dldungeons.planner.Node;
import jaredbgreat.dldungeons.planner.PlaceSeed;
import jaredbgreat.dldungeons.planner.Route;
import jaredbgreat.dldungeons.planner.astar.DoorChecker;
import jaredbgreat.dldungeons.planner.mapping.MapMatrix;
import jaredbgreat.dldungeons.rooms.Cave;
import jaredbgreat.dldungeons.rooms.Room;
import jaredbgreat.dldungeons.rooms.RoomList;
import jaredbgreat.dldungeons.themes.BiomeLists;
import jaredbgreat.dldungeons.themes.Degrees;
import jaredbgreat.dldungeons.themes.Sizes;
import jaredbgreat.dldungeons.themes.Theme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Dungeon {
    public Theme theme;
    public Random random;
    public BiomeGenBase biome;
    public MapMatrix map;
    public Node[] nodes;
    public int numNodes;
    public int roomCount;
    public int entrancePref;
    public int baseHeight;
    public int numEntrances = 0;
    public RoomList rooms;
    public RoomList nodeRooms;
    public ArrayList<Room> planter;
    public ArrayList<Room> grower;
    public Sizes size;
    public Degrees outside;
    public Degrees liquids;
    public Degrees subrooms;
    public Degrees islands;
    public Degrees pillars;
    public Degrees fences;
    public Degrees symmetry;
    public Degrees variability;
    public Degrees degeneracy;
    public Degrees complexity;
    public Degrees verticle;
    public Degrees entrances;
    public Degrees bigRooms;
    public Degrees naturals;
    public int wallBlock1;
    public int floorBlock;
    public int cielingBlock;
    public int stairBlock;
    public int stairSlab;
    public int fenceBlock;
    public int cornerBlock;
    public int liquidBlock;
    public int caveBlock;
    int shiftX;
    int shiftZ;

    public void preFinalize() {
        if (this.theme != null) {
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i] = null;
            }
            for (Room room : this.rooms) {
                room.preFinalize();
                Object var2_3 = null;
            }
            this.rooms.clear();
        }
        this.rooms = null;
        this.grower = null;
        this.planter = null;
        this.nodes = null;
        this.theme = null;
        this.random = null;
        this.biome = null;
        this.map = null;
        this.size = null;
        this.outside = null;
        this.liquids = null;
        this.subrooms = null;
        this.islands = null;
        this.pillars = null;
        this.symmetry = null;
        this.variability = null;
        this.degeneracy = null;
        this.complexity = null;
        this.verticle = null;
        this.entrances = null;
        this.bigRooms = null;
        this.naturals = null;
    }

    public Dungeon(Random random, BiomeGenBase biome, World world, int chunkX, int chunkZ) throws Throwable {
        DoomlikeDungeons.profiler.startTask("Planning Dungeon");
        DoomlikeDungeons.profiler.startTask("Layout dungeon (rough draft)");
        this.random = new Random(random.nextLong());
        this.biome = biome;
        this.theme = BiomeLists.getTheme(biome, random);
        if (this.theme == null) {
            return;
        }
        this.applyTheme();
        this.entrancePref = random.nextInt(3);
        this.wallBlock1 = this.theme.walls[random.nextInt(this.theme.walls.length)];
        this.floorBlock = this.theme.floors[random.nextInt(this.theme.floors.length)];
        this.cielingBlock = this.theme.ceilings[random.nextInt(this.theme.ceilings.length)];
        this.fenceBlock = this.theme.fencing[random.nextInt(this.theme.fencing.length)];
        this.cornerBlock = this.theme.pillarBlock[random.nextInt(this.theme.pillarBlock.length)];
        this.liquidBlock = this.theme.liquid[random.nextInt(this.theme.liquid.length)];
        this.caveBlock = this.theme.caveWalls[random.nextInt(this.theme.caveWalls.length)];
        this.rooms = new RoomList(this.size.maxRooms + 1);
        this.planter = new ArrayList();
        this.map = new MapMatrix(this.size.width, world, chunkX, chunkZ);
        this.numNodes = random.nextInt(this.size.maxNodes - this.size.minNodes + 1) + this.size.minNodes + 1;
        this.nodes = new Node[this.numNodes];
        this.shiftX = this.map.chunkX * 16 - this.map.room.length / 2 + 8;
        this.shiftZ = this.map.chunkZ * 16 - this.map.room.length / 2 + 8;
        this.makeNodes();
        if (this.numEntrances < 1 && ConfigHandler.easyFind) {
            this.addAnEntrance();
        }
        this.connectNodes();
        this.growthCycle();
        DoomlikeDungeons.profiler.endTask("Layout dungeon (rough draft)");
        DoomlikeDungeons.profiler.startTask("Fixing room contents");
        this.fixRoomContents();
        DoomlikeDungeons.profiler.endTask("Fixing room contents");
        DoomlikeDungeons.profiler.endTask("Planning Dungeon");
    }

    private void applyTheme() {
        this.size = this.theme.sizes.select(this.random);
        this.outside = this.theme.outside.select(this.random);
        this.liquids = this.theme.liquids.select(this.random);
        this.subrooms = this.theme.subrooms.select(this.random);
        this.islands = this.theme.islands.select(this.random);
        this.pillars = this.theme.pillars.select(this.random);
        this.symmetry = this.theme.symmetry.select(this.random);
        this.variability = this.theme.variability.select(this.random);
        this.degeneracy = this.theme.degeneracy.select(this.random);
        this.complexity = this.theme.complexity.select(this.random);
        this.verticle = this.theme.verticle.select(this.random);
        this.entrances = this.theme.entrances.select(this.random);
        this.fences = this.theme.fences.select(this.random);
        this.naturals = this.theme.naturals.select(this.random);
        this.baseHeight = this.random.nextInt(this.theme.maxY - this.theme.minY) + this.theme.minY;
    }

    void makeNodes() {
        int height = this.baseHeight;
        this.nodeRooms = new RoomList(this.numNodes);
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes[i] = new Node(this.random.nextInt(this.size.width), height, this.random.nextInt(this.size.width), this.random, this);
        }
    }

    void connectNodes() throws Throwable {
        for (int i = 0; i < this.nodes.length; ++i) {
            Node first = this.nodes[i];
            if (first == null || first.hubRoom == null) continue;
            for (int j = i + 1; j < this.nodes.length; ++j) {
                Node other = this.nodes[j];
                if (other == null || other.hubRoom == null) continue;
                if (this.rooms.realSize() >= this.size.maxRooms) {
                    return;
                }
                if (other == first) continue;
                new Route(first, other).drawConnections(this);
            }
        }
    }

    void makeMoreRooms() {
        while (this.rooms.realSize() < this.size.maxRooms) {
            int height = this.baseHeight;
            int x = this.random.nextInt(this.size.width);
            int z = this.random.nextInt(this.size.width);
            int xdim = this.random.nextInt(this.size.maxRoomSize - 5) + 6;
            int zdim = this.random.nextInt(this.size.maxRoomSize - 5) + 6;
            if (this.bigRooms.use(this.random)) {
                xdim += this.random.nextInt(this.size.maxRoomSize / 2) + this.size.maxRoomSize / 2;
                zdim += this.random.nextInt(this.size.maxRoomSize / 2) + this.size.maxRoomSize / 2;
            }
            int ymod = xdim <= zdim ? (int)Math.sqrt(xdim) : (int)Math.sqrt(zdim);
            int roomHeight = this.random.nextInt(this.verticle.value / 2 + ymod + 1) + 2;
            Room room = new PlaceSeed(x, height, z).growRoom(xdim, zdim, roomHeight, this, null, null);
        }
    }

    public void growthCycle() {
        boolean doMore = true;
        do {
            doMore = false;
            this.grower = this.planter;
            Collections.shuffle(this.grower, this.random);
            this.planter = new ArrayList();
            for (Room room : this.grower) {
                if (this.rooms.realSize() >= this.size.maxRooms) {
                    return;
                }
                if (!room.plantChildren(this)) continue;
                doMore = true;
            }
        } while (doMore);
    }

    public void fixRoomContents() {
        for (Room room : this.rooms) {
            this.addChestBlocks(room);
            DoorChecker.processDoors1(this, room);
        }
        for (Room room : this.rooms) {
            DoorChecker.processDoors2(this, room);
        }
        for (Room room : this.rooms) {
            DoorChecker.processDoors3(this, room);
            if (!(room instanceof Cave)) continue;
            DoorChecker.caveConnector(this, room);
        }
        DoorChecker.checkConnectivity(this);
    }

    public void addTileEntities() {
        for (Room room : this.rooms) {
            this.addTileEntitesToRom(room);
        }
    }

    public void addTileEntitesToRom(Room room) {
        for (Spawner spawner : room.spawners) {
            DBlock.placeSpawner(this.map.world, this.shiftX + spawner.x, spawner.y, this.shiftZ + spawner.z, spawner.mob);
        }
        for (BasicChest chest : room.chests) {
            chest.place(this.map.world, this.shiftX + chest.mx, chest.my, this.shiftZ + chest.mz, this.random);
        }
    }

    public void addChestBlocks(Room room) {
        for (BasicChest chest : room.chests) {
            DBlock.placeChest(this.map.world, this.shiftX + chest.mx, chest.my, this.shiftZ + chest.mz);
        }
    }

    public void addEntrances() {
        for (Room room : this.nodeRooms) {
            if (room == null) continue;
            this.addEntrance(room);
        }
    }

    public void addEntrance(Room room) {
        if (!room.hasEntrance) {
            return;
        }
        int entrance = this.variability.use(this.random) ? this.random.nextInt(3) : this.entrancePref;
        if (ConfigHandler.easyFind) {
            entrance = 1;
        }
        switch (entrance) {
            case 0: {
                new SpiralStair((int)room.realX, room.floorY, (int)room.realZ).build(this, this.map.world);
                break;
            }
            case 1: {
                new TopRoom((int)room.realX, room.floorY, (int)room.realZ).build(this, this.map.world);
                break;
            }
            default: {
                new SimpleEntrance((int)room.realX, room.floorY, (int)room.realZ).build(this, this.map.world);
            }
        }
    }

    public void addAnEntrance() {
        if (this.theme.entrances.never()) {
            return;
        }
        int which = this.random.nextInt(this.nodes.length);
        Room it = this.nodes[which].hubRoom;
        it.chests.clear();
        it.spawners.clear();
        it.hasEntrance = true;
        it.hasSpawners = false;
        this.numEntrances = 1;
        for (int i = (int)it.realX - 2; i < (int)it.realX + 2; ++i) {
            for (int j = (int)it.realZ - 2; j < (int)it.realZ + 2; ++j) {
                this.map.floorY[i][j] = (byte)it.floorY;
                this.map.hasLiquid[i][j] = false;
                this.map.isWall[i][j] = false;
            }
        }
    }
}

