/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner.astar;

import jaredbgreat.dldungeons.pieces.Doorway;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.planner.astar.AStar;
import jaredbgreat.dldungeons.planner.astar.AStar2;
import jaredbgreat.dldungeons.planner.astar.DoorQueue;
import jaredbgreat.dldungeons.planner.astar.RoomBFS;
import jaredbgreat.dldungeons.planner.mapping.Tile;
import jaredbgreat.dldungeons.rooms.Room;
import jaredbgreat.dldungeons.themes.ThemeFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class DoorChecker {
    static CompareLists c = new CompareLists();

    public static boolean validateTile(Dungeon dungeon, Tile tile) {
        if (tile.x < 0 || tile.x >= dungeon.size.width) {
            return false;
        }
        if (tile.z < 0 || tile.z >= dungeon.size.width) {
            return false;
        }
        return dungeon.map.room[tile.x][tile.z] > 0;
    }

    public static boolean validateTile(Dungeon dungeon, int x, int z) {
        if (x < 0 || x >= dungeon.size.width) {
            return false;
        }
        if (z < 0 || z >= dungeon.size.width) {
            return false;
        }
        return dungeon.map.room[x][z] > 0;
    }

    public static boolean validateDoor(Dungeon dungeon, Doorway door) {
        if (door.xOriented) {
            if (DoorChecker.validateTile(dungeon, door.x - 1, door.z) && DoorChecker.validateTile(dungeon, door.x + 1, door.z)) {
                return true;
            }
            dungeon.map.isDoor[door.x][door.z] = false;
            return false;
        }
        if (DoorChecker.validateTile(dungeon, door.x, door.z - 1) && DoorChecker.validateTile(dungeon, door.x, door.z + 1)) {
            return true;
        }
        dungeon.map.isDoor[door.x][door.z] = false;
        return false;
    }

    public static ArrayList<Doorway> makeConnectionList(Room room, Random random) {
        ArrayList<Doorway> out = new ArrayList<Doorway>(room.connections.size());
        for (DoorQueue exits : room.connections) {
            out.add((Doorway)exits.peek());
        }
        Collections.shuffle(out, random);
        return out;
    }

    public static int getOtherRoom(Doorway exit, Room room, Dungeon dungeon) {
        if (exit.xOriented) {
            if (dungeon.map.room[exit.x + 1][exit.z] == room.id) {
                return dungeon.map.room[exit.x - 1][exit.z];
            }
            if (dungeon.map.room[exit.x - 1][exit.z] == room.id) {
                return dungeon.map.room[exit.x + 1][exit.z];
            }
        } else {
            if (dungeon.map.room[exit.x][exit.z + 1] == room.id) {
                return dungeon.map.room[exit.x][exit.z - 1];
            }
            if (dungeon.map.room[exit.x][exit.z - 1] == room.id) {
                return dungeon.map.room[exit.x][exit.z + 1];
            }
        }
        return 0;
    }

    public static void checkConnections(ArrayList<Doorway> exits, Room room, Dungeon dungeon) {
        if (exits.isEmpty()) {
            return;
        }
        ArrayList<Doorway> connected = new ArrayList<Doorway>(exits.size());
        connected.add(exits.remove(exits.size() - 1));
        while (!exits.isEmpty()) {
            Doorway current = (Doorway)connected.get(0);
            Doorway next = exits.remove(exits.size() - 1);
            connected.add(next);
            new AStar(room, dungeon, current, next).seek();
            Collections.shuffle(connected, dungeon.random);
        }
    }

    public static void retestDoors(Dungeon dungeon, Room room) {
        if (room.doors.isEmpty()) {
            return;
        }
        for (Doorway door : room.doors) {
            if (dungeon.map.astared[door.x][door.z]) continue;
            if (door.xOriented) {
                if (dungeon.map.isWall[door.x + 1][door.z] || dungeon.map.isWall[door.x - 1][door.z]) {
                    dungeon.map.isDoor[door.x][door.z] = false;
                }
                if (dungeon.map.hasLiquid[door.x + 1][door.z] != dungeon.map.hasLiquid[door.x - 1][door.z]) {
                    dungeon.map.isDoor[door.x][door.z] = false;
                }
                if (!dungeon.map.hasLiquid[door.x + 1][door.z]) continue;
                dungeon.map.hasLiquid[door.x][door.z] = true;
                if (dungeon.theme.flags.contains((Object)ThemeFlags.SWAMPY)) {
                    dungeon.map.floorY[door.x][door.z] = (byte)(room.floorY - 1);
                    continue;
                }
                dungeon.map.floorY[door.x][door.z] = (byte)(room.floorY - 2);
                continue;
            }
            if (dungeon.map.isWall[door.x][door.z + 1] || dungeon.map.isWall[door.x][door.z - 1]) {
                dungeon.map.isDoor[door.x][door.z] = false;
            }
            if (dungeon.map.hasLiquid[door.x][door.z + 1] != dungeon.map.hasLiquid[door.x][door.z - 1]) {
                dungeon.map.isDoor[door.x][door.z] = false;
            }
            if (!dungeon.map.hasLiquid[door.x][door.z + 1]) continue;
            dungeon.map.hasLiquid[door.x][door.z] = true;
            if (dungeon.theme.flags.contains((Object)ThemeFlags.SWAMPY)) {
                dungeon.map.floorY[door.x][door.z] = (byte)(room.floorY - 1);
                continue;
            }
            dungeon.map.floorY[door.x][door.z] = (byte)(room.floorY - 2);
        }
    }

    public static void processDoors1(Dungeon dungeon, Room room) {
        ArrayList<Doorway> invalid = new ArrayList<Doorway>();
        for (Doorway door : room.doors) {
            boolean valid = DoorChecker.validateDoor(dungeon, door);
            if (!valid) {
                invalid.add(door);
                continue;
            }
            door.prioritize(dungeon, room.id);
            room.addToConnections(door);
        }
        room.doors.removeAll(invalid);
    }

    public static void checkConnectivity(Dungeon dungeon) {
        ArrayList<ArrayList<Room>> sections = new RoomBFS(dungeon).check();
        while (sections.size() > 1) {
            Collections.sort(sections, c);
            new AStar2(dungeon, sections.get(0).get(0), sections.get(1).get(0)).seek();
            sections.get(1).addAll((Collection<Room>)sections.get(0));
            sections.remove(0);
        }
    }

    public static void processDoors2(Dungeon dungeon, Room room) {
        room.topDoors = DoorChecker.makeConnectionList(room, dungeon.random);
        for (Doorway exit : room.topDoors) {
            exit.priority = -16;
            ((Room)dungeon.rooms.get(DoorChecker.getOtherRoom(exit, room, dungeon))).addToConnections(exit);
        }
    }

    public static void processDoors3(Dungeon dungeon, Room room) {
        DoorChecker.checkConnections(room.topDoors, room, dungeon);
        DoorChecker.retestDoors(dungeon, room);
    }

    public static void caveConnector(Dungeon dungeon, Room cave) {
        for (Doorway door : cave.doors) {
            new AStar2(dungeon, cave, (Room)dungeon.rooms.get(door.otherside)).seek();
        }
    }

    public static class CompareLists
    implements Comparator<List> {
        @Override
        public int compare(List o1, List o2) {
            return o1.size() - o2.size();
        }
    }
}

