/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.rooms;

import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.rooms.Room;

public class Cave
extends Room {
    private int xSize;
    private int zSize;
    private int layers;
    private int[][][] cells;
    private int[][] scratchpad;
    private int sum;

    public Cave(int beginX, int endX, int beginZ, int endZ, int floorY, int ceilY, Dungeon dungeon, Room parent, Room previous) {
        super(beginX, endX, beginZ, endZ, floorY, ceilY, dungeon, previous, previous);
        this.degenerate = true;
    }

    @Override
    public Room plan(Dungeon dungeon, Room parent) {
        int j;
        int i;
        int k;
        int j2;
        int i2;
        this.xSize = this.endX - this.beginX;
        this.zSize = this.endZ - this.beginZ;
        this.layers = dungeon.verticle.ordinal();
        if (this.layers < 1) {
            this.layers = 1;
        }
        this.cells = new int[this.layers][this.xSize][this.zSize];
        for (i2 = 0; i2 < this.xSize; ++i2) {
            for (j2 = 0; j2 < this.zSize; ++j2) {
                for (k = 0; k < this.layers; ++k) {
                    this.cells[k][i2][j2] = dungeon.random.nextInt(2);
                }
            }
        }
        this.cells[0] = this.layerConvert1(this.cells[0], 5 + dungeon.random.nextInt(2));
        for (i2 = 0; i2 < this.xSize; ++i2) {
            for (j2 = 0; j2 < this.zSize; ++j2) {
                if (this.cells[0][i2][j2] != 1) continue;
                dungeon.map.isWall[i2 + this.beginX][j2 + this.beginZ] = true;
            }
        }
        int tmpFY = this.floorY;
        int tmpCY = this.ceilY;
        for (k = 1; k < this.layers; ++k) {
            this.cells[k] = this.layerConvert2(this.cells[k], k - 1, 4 + dungeon.random.nextInt(3));
            if ((tmpCY += dungeon.random.nextInt(3) - 1) - (tmpFY += dungeon.random.nextInt(3) - 1) < 3) {
                tmpCY = tmpFY + 3;
            }
            for (int i3 = 0; i3 < this.xSize; ++i3) {
                for (int j3 = 0; j3 < this.zSize; ++j3) {
                    if (this.cells[k][i3][j3] != 0) continue;
                    dungeon.map.floorY[i3 + this.beginX][j3 + this.beginZ] = (byte)tmpFY;
                    dungeon.map.nFloorY[i3 + this.beginX][j3 + this.beginZ] = (byte)tmpFY;
                    dungeon.map.ceilY[i3 + this.beginX][j3 + this.beginZ] = (byte)tmpCY;
                    dungeon.map.nCeilY[i3 + this.beginX][j3 + this.beginZ] = (byte)tmpCY;
                }
            }
        }
        if (this.hasEntrance) {
            for (i = (int)this.realX - 2; i < (int)this.realX + 2; ++i) {
                for (j = (int)this.realZ - 2; j < (int)this.realZ + 2; ++j) {
                    dungeon.map.floorY[i][j] = (byte)this.floorY;
                    dungeon.map.hasLiquid[i][j] = false;
                    dungeon.map.isWall[i][j] = false;
                }
            }
        }
        if (parent == null) {
            this.addSpawners(dungeon);
            this.addChests(dungeon);
        }
        if (dungeon.naturals.use(dungeon.random) || !dungeon.variability.use(dungeon.random)) {
            for (i = this.beginX; i < this.endX; ++i) {
                for (j = this.beginZ; j < this.endZ; ++j) {
                    dungeon.map.wall[i][j] = this.caveBlock;
                    dungeon.map.floor[i][j] = this.caveBlock;
                    dungeon.map.ceiling[i][j] = this.caveBlock;
                }
            }
        }
        return this;
    }

    private int[][] layerConvert1(int[][] layer, int thresshold) {
        this.makeScratchpad();
        for (int i = this.xSize - 2; i > 0; --i) {
            for (int j = this.zSize - 2; j > 0; --j) {
                this.processCell(layer, i, j, thresshold);
            }
        }
        return this.scratchpad;
    }

    private int[][] layerConvert2(int[][] layer, int down, int thresshold) {
        int j;
        int i;
        this.makeScratchpad();
        for (i = this.xSize - 2; i > 0; --i) {
            for (j = this.zSize - 2; j > 0; --j) {
                if (this.cells[down][i][j] != 1) continue;
                layer[i][j] = 1;
            }
        }
        for (i = this.xSize - 2; i > 0; --i) {
            for (j = this.zSize - 2; j > 0; --j) {
                this.processCell(layer, i, j, thresshold);
            }
        }
        return this.scratchpad;
    }

    private void processCell(int[][] layer, int x, int z, int thresshold) {
        this.sum = 0;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = z - 1; j <= z + 1; ++j) {
                this.sum += layer[i][j];
            }
        }
        this.scratchpad[x][z] = this.sum >= thresshold ? 1 : 0;
    }

    private void makeScratchpad() {
        int i;
        this.scratchpad = new int[this.xSize][this.zSize];
        for (i = 0; i < this.xSize; ++i) {
            this.scratchpad[i][0] = 1;
            this.scratchpad[i][this.zSize - 1] = 1;
        }
        for (i = 0; i < this.zSize; ++i) {
            this.scratchpad[0][1] = 1;
            this.scratchpad[this.xSize - 1][i] = 1;
        }
    }
}

