/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.setup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public class Externalizer {
    private BufferedReader instream;
    private BufferedWriter outstream;
    private File outFile;
    private static final String baseLocation = "/jaredbgreat/dldungeons/res/themes/";
    private static String outDirectory;
    private static final String[] themes;

    public Externalizer(String outDir) {
        outDirectory = outDir;
    }

    public void copyOut(String name) {
        try {
            this.outFile = new File(outDirectory + name);
            if (this.outFile.exists()) {
                return;
            }
            this.instream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(baseLocation + name)));
            this.outstream = new BufferedWriter(new FileWriter(this.outFile));
            if (this.instream != null && this.outstream != null) {
                String line;
                while ((line = this.instream.readLine()) != null) {
                    this.outstream.write(line + System.lineSeparator());
                }
            } else {
                System.err.println("[DLDUNGEONS] Error! Failed to write theme file " + this.outFile);
            }
            if (this.instream != null) {
                this.instream.close();
            }
            if (this.outstream != null) {
                this.outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error! Failed to write theme file " + this.outFile);
        }
    }

    public boolean forceOut(String name) {
        boolean result = true;
        try {
            this.outFile = new File(outDirectory + name);
            if (this.outFile.exists()) {
                if (this.outFile.canWrite() && !this.outFile.isDirectory()) {
                    this.outFile.delete();
                } else {
                    System.err.println("[DLDUNGEONS] Warning, could not delete " + this.outFile);
                    result = false;
                }
            }
            this.instream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(baseLocation + name)));
            this.outstream = new BufferedWriter(new FileWriter(this.outFile));
            if (this.instream != null && this.outstream != null) {
                String line;
                while ((line = this.instream.readLine()) != null) {
                    this.outstream.write(line + System.lineSeparator());
                }
            } else {
                System.err.println("[DLDUNGEONS] Error! Failed to write theme file " + this.outFile);
                result = false;
            }
            if (this.instream != null) {
                this.instream.close();
            }
            if (this.outstream != null) {
                this.outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error! Failed to write theme file " + this.outFile);
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public void makeThemes() {
        for (String name : themes) {
            System.out.println("[DLDUNGEONS] Installing file " + outDirectory + name);
            this.copyOut(name);
        }
    }

    public void forceThemes() {
        for (String name : themes) {
            System.out.println("[DLDUNGEONS] Installing file " + outDirectory + name);
            this.forceOut(name);
        }
    }

    public void makeChestCfg() {
        System.out.println("[DLDUNGEONS] Installing file " + outDirectory + "chests.cfg");
        this.copyOut("chests.cfg");
    }

    public void forceChestCfg() {
        System.out.println("[DLDUNGEONS] Installing file " + outDirectory + "chests.cfg");
        this.forceOut("chests.cfg");
    }

    static {
        themes = new String[]{"common.cfg", "continentalShelf.cfg", "dank.cfg", "desert.cfg", "frozen.cfg", "jungle.cfg", "mesa.cfg", "nether.cfg", "oceanic.cfg", "template.cfg", "urban.cfg", "villagelike.cfg", "volcanic.cfg"};
    }
}

