/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.converter;

import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableStringConverter;

public class AccountConverter
extends LocalizableStringConverter<Account> {
    private final ProfileManager pm;

    public AccountConverter(ProfileManager pm) {
        super(null);
        if (pm == null) {
            throw new NullPointerException();
        }
        this.pm = pm;
    }

    @Override
    public String toString(Account from) {
        return from == null ? Localizable.get("account.empty") : (from.getUsername() == null ? null : from.getUsername());
    }

    @Override
    public Account fromString(String from) {
        return this.pm.getAuthDatabase().getByUsername(from);
    }

    @Override
    public String toValue(Account from) {
        return from != null && from.getUsername() != null ? from.getUsername() : null;
    }

    @Override
    public String toPath(Account from) {
        return null;
    }

    @Override
    public Class<Account> getObjectClass() {
        return Account.class;
    }
}

