/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.minecraft.launcher.updater.LatestVersionSyncInfo;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.ReleaseType;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.util.U;

public class VersionCellRenderer
implements ListCellRenderer<VersionSyncInfo> {
    public static final VersionSyncInfo LOADING = VersionSyncInfo.createEmpty();
    public static final VersionSyncInfo EMPTY = VersionSyncInfo.createEmpty();
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private final int averageColor = new Color(128, 128, 128, 255).getRGB();
    private static final Icon ELY_ICON = ImageCache.getIcon("ely.png");

    @Override
    public Component getListCellRendererComponent(JList<? extends VersionSyncInfo> list, VersionSyncInfo value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel mainText = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        mainText.setAlignmentY(0.5f);
        if (value == null) {
            mainText.setText("(null)");
        } else if (value.equals(LOADING)) {
            mainText.setText(Localizable.get("versions.loading"));
        } else if (value.equals(EMPTY)) {
            mainText.setText(Localizable.get("versions.notfound.tip"));
        } else {
            mainText.setText(VersionCellRenderer.getLabelFor(value));
            if (this.getShowElyVersions() && TLauncher.getInstance().getElyManager().hasLibraries(value)) {
                mainText.setIcon(ELY_ICON);
            }
            if (!value.isInstalled()) {
                mainText.setBackground(U.shiftColor(mainText.getBackground(), mainText.getBackground().getRGB() < this.averageColor ? 32 : -32));
            }
        }
        return mainText;
    }

    public static String getLabelFor(VersionSyncInfo value) {
        String label;
        String id;
        LatestVersionSyncInfo asLatest = value instanceof LatestVersionSyncInfo ? (LatestVersionSyncInfo)value : null;
        ReleaseType type = value.getAvailableVersion().getReleaseType();
        if (asLatest == null) {
            id = value.getID();
            label = "version." + (Object)((Object)type);
        } else {
            id = asLatest.getVersionID();
            label = "version.latest." + (Object)((Object)type);
        }
        label = Localizable.nget(label);
        switch (SyntheticClass_1.$SwitchMap$net$minecraft$launcher$versions$ReleaseType[type.ordinal()]) {
            case 1: {
                id = id.startsWith("a") ? id.substring(1) : id;
                break;
            }
            case 2: {
                id = id.substring(1);
            }
        }
        String text = label != null ? label + " " + id : id;
        return text;
    }

    public boolean getShowElyVersions() {
        return false;
    }

    static class SyntheticClass_1 {
        static final int[] $SwitchMap$net$minecraft$launcher$versions$ReleaseType = new int[ReleaseType.values().length];

        SyntheticClass_1() {
        }

        static {
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$launcher$versions$ReleaseType[ReleaseType.OLD_ALPHA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$launcher$versions$ReleaseType[ReleaseType.OLD_BETA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

