/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.scenes.VersionManagerScene;
import ru.turikhay.tlauncher.ui.versions.VersionHandlerListener;
import ru.turikhay.tlauncher.ui.versions.VersionHandlerThread;
import ru.turikhay.tlauncher.ui.versions.VersionList;

public class VersionHandler
implements Blockable,
VersionHandlerListener {
    static final int ELEM_WIDTH = 300;
    public static final String REFRESH_BLOCK = "refresh";
    public static final String SINGLE_SELECTION_BLOCK = "single-select";
    public static final String START_DOWNLOAD = "start-download";
    public static final String STOP_DOWNLOAD = "stop-download";
    public static final String DELETE_BLOCK = "deleting";
    private final List<VersionHandlerListener> listeners;
    private final VersionHandler instance = this;
    public final VersionManagerScene scene;
    final VersionHandlerThread thread;
    public final VersionList list;
    final VersionManager vm;
    final Downloader downloader;
    List<VersionSyncInfo> selected;
    List<VersionSyncInfo> downloading;
    VersionFilter filter;

    public VersionHandler(VersionManagerScene scene) {
        this.scene = scene;
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.downloading = Collections.synchronizedList(new ArrayList());
        TLauncher launcher = TLauncher.getInstance();
        this.vm = launcher.getVersionManager();
        this.downloader = launcher.getDownloader();
        this.list = new VersionList(this);
        this.thread = new VersionHandlerThread(this);
        this.vm.addListener(new VersionManagerListener(){

            @Override
            public void onVersionsRefreshing(VersionManager manager) {
                VersionHandler.this.instance.onVersionRefreshing(manager);
            }

            @Override
            public void onVersionsRefreshed(VersionManager manager) {
                VersionHandler.this.instance.onVersionRefreshed(manager);
            }

            @Override
            public void onVersionsRefreshingFailed(VersionManager manager) {
                this.onVersionsRefreshed(manager);
            }
        });
        this.onVersionDeselected();
    }

    void addListener(VersionHandlerListener listener) {
        this.listeners.add(listener);
    }

    void update() {
        if (this.selected != null) {
            this.onVersionSelected(this.selected);
        }
    }

    void refresh() {
        this.vm.startRefresh(true);
    }

    void asyncRefresh() {
        this.vm.asyncRefresh();
    }

    public void stopRefresh() {
        this.vm.stopRefresh();
    }

    void exitEditor() {
        this.list.deselect();
        this.scene.getMainPane().openDefaultScene();
    }

    VersionSyncInfo getSelected() {
        return this.selected != null && this.selected.size() == 1 ? this.selected.get(0) : null;
    }

    List<VersionSyncInfo> getSelectedList() {
        return this.selected;
    }

    @Override
    public void block(Object reason) {
        Blocker.block(reason, this.list, this.scene.getMainPane().defaultScene);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblock(reason, this.list, this.scene.getMainPane().defaultScene);
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
        Blocker.block(this.instance, REFRESH_BLOCK);
        for (VersionHandlerListener listener : this.listeners) {
            listener.onVersionRefreshing(vm);
        }
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
        Blocker.unblock(this.instance, REFRESH_BLOCK);
        for (VersionHandlerListener listener : this.listeners) {
            listener.onVersionRefreshed(vm);
        }
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> version) {
        this.selected = version;
        if (version != null && !version.isEmpty() && version.get(0).getID() != null) {
            for (VersionHandlerListener listener : this.listeners) {
                listener.onVersionSelected(version);
            }
        } else {
            this.onVersionDeselected();
        }
    }

    @Override
    public void onVersionDeselected() {
        this.selected = null;
        for (VersionHandlerListener listener : this.listeners) {
            listener.onVersionDeselected();
        }
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
        this.downloading = list;
        for (VersionHandlerListener listener : this.listeners) {
            listener.onVersionDownload(list);
        }
    }
}

