/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import ru.turikhay.util.async.ExtendedThread;

public abstract class LoopedThread
extends ExtendedThread {
    protected static final String LOOPED_BLOCK = "iteration";

    public LoopedThread(String name) {
        super(name);
    }

    public LoopedThread() {
        this("LoopedThread");
    }

    @Override
    protected final void lockThread(String reason) {
        if (reason == null) {
            throw new NullPointerException();
        }
        if (!reason.equals(LOOPED_BLOCK)) {
            throw new IllegalArgumentException("Illegal block reason. Expected: iteration, got: " + reason);
        }
        super.lockThread(reason);
    }

    public final boolean isIterating() {
        return !this.isThreadLocked();
    }

    public final void iterate() {
        if (!this.isIterating()) {
            this.unlockThread(LOOPED_BLOCK);
        }
    }

    @Override
    public final void run() {
        while (true) {
            this.lockThread(LOOPED_BLOCK);
            this.iterateOnce();
        }
    }

    protected abstract void iterateOnce();
}

