/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.salf.connection;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.salf.connection.ServerEntity;

public class ConfigSeacher {
    private String urlServer;
    private String nameFile;

    public ConfigSeacher(String urlServer, String nameFile) {
        this.urlServer = urlServer;
        this.nameFile = nameFile;
    }

    private ServerEntity readConfigFromFile() throws IOException {
        if (!FileUtil.fileExists(new File(MinecraftUtil.getWorkingDirectory(), this.nameFile).getCanonicalPath())) {
            return null;
        }
        String dataJson = FileUtil.readFile(new File(MinecraftUtil.getWorkingDirectory(), this.nameFile));
        return new Gson().fromJson(dataJson, ServerEntity.class);
    }

    public void saveConfigFromServer() throws IOException {
        String server = FileUtil.getTextResource(new URL(this.urlServer));
        FileUtil.rewriteFile(new File(MinecraftUtil.getWorkingDirectory(), this.nameFile), server);
    }

    private ServerEntity readOldServer() throws IOException {
        ServerEntity server = this.readConfigFromFile();
        if (server == null) {
            this.saveConfigFromServer();
            server = this.readConfigFromFile();
        }
        if (server == null) {
            throw new NullPointerException("didn't receive data from filenameFile=" + this.nameFile + " urlServer=" + this.urlServer);
        }
        return server;
    }

    public ServerEntity readServer() throws IOException {
        try {
            return this.readOldServer();
        }
        catch (JsonParseException var2) {
            this.saveConfigFromServer();
            return this.readOldServer();
        }
    }
}

