/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.review;

import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileNameExtensionFilter;
import ru.turikhay.tlauncher.entity.Review;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.review.ProgressBar;
import ru.turikhay.tlauncher.ui.review.ReviewButton;
import ru.turikhay.tlauncher.ui.review.ReviewJTextArea;
import ru.turikhay.tlauncher.ui.review.ReviewWindowController;
import ru.turikhay.tlauncher.ui.review.ValidateReview;
import ru.turikhay.tlauncher.ui.util.ViewlUtil;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.review.FolderEnum;

public class ReviewWindowView
extends JFrame {
    private JFrame parent;
    private JLabel wishesTitle;
    private StyledLabel wishesDescription;
    private JLabel mailLabel;
    private JLabel titleReviewLabel;
    private JTextField titleReview;
    private JComboBox<String> titleReviewBox;
    private ReviewJTextArea description;
    private JTextField mailReview;
    private ProgressBar progressBar;
    private JPanel titleDescriptionPanel;
    private JPanel reviewPanel;
    private JPanel buttonPanel;
    private JPanel mailPanel;
    private JPanel deleteButtonsPanel;
    private JPanel actionReviewPanel;
    private JButton addFile;
    private JButton close;
    private JButton send;
    private JButton cancel;
    private SpringLayout layout;
    private ReviewWindowController controller;
    public static final FileNameExtensionFilter filter = new FileNameExtensionFilter("filter", "zip", "txt", "rar", "doc", "pdf", "log", "gz", "png", "jpeg", "jpg");

    public ReviewWindowView(JFrame parent, ReviewWindowController controller) {
        this.controller = controller;
        this.parent = parent;
        this.buttonPanel = new JPanel(new FlowLayout(0));
        this.titleDescriptionPanel = new JPanel(new FlowLayout(0));
        this.mailPanel = new JPanel(new FlowLayout(0));
        this.reviewPanel = new JPanel();
        this.deleteButtonsPanel = new JPanel(new FlowLayout(0));
        this.actionReviewPanel = new JPanel(new FlowLayout(2));
        this.wishesTitle = new JLabel(Localizable.get().get("review.window.title"));
        this.wishesDescription = new StyledLabel(Localizable.get().get("review.label.wishesDescription"));
        this.send = new ReviewButton(Localizable.get().get("review.button.send"));
        this.close = new ReviewButton(Localizable.get().get("review.button.close"));
        this.addFile = new ReviewButton(Localizable.get().get("review.button.addFile"));
        this.mailLabel = new JLabel(Localizable.get().get("review.label.mail"));
        this.titleReviewLabel = new JLabel(Localizable.get().get("review.label.titleReview"));
        this.cancel = new JButton(Localizable.get().get("ui.cancel"));
        this.titleReview = new JTextField(20);
        this.mailReview = new JTextField(20);
        this.titleReviewBox = new JComboBox<String>(Localizable.get().get("review.box.typeReviewBox").split(","));
        this.description = new ReviewJTextArea(5, 5);
        this.layout = new SpringLayout();
        this.progressBar = new ProgressBar(this, this.cancel);
        this.mailLabel.setPreferredSize(new Dimension(140, this.titleReview.getFont().getSize() + 5));
        this.titleReviewLabel.setPreferredSize(new Dimension(140, this.titleReview.getFont().getSize() + 5));
        this.setTitle(Localizable.get().get("review.label.wishesTitle"));
        Dimension dimension = ViewlUtil.calculateSizeReview(parent);
        this.setPreferredSize(dimension);
        this.setLocation(ViewlUtil.calculatePosition(parent, dimension));
        this.setResizable(false);
        this.setLayout(this.layout);
        SwingUtil.setFavicons(this);
        this.reviewPanel.setLayout(new BoxLayout(this.reviewPanel, 1));
        this.reviewPanel.setAlignmentX(0.0f);
        this.description.setText(Localizable.get().get("review.description"));
        this.description.setForeground(new Color(152, 153, 146));
        this.description.setLineWrap(true);
        this.wishesDescription.setLineWrap(true);
        this.wishesDescription.setFont(new Font("Tahoma", 0, 13));
        this.titleDescriptionPanel.add(this.titleReviewLabel);
        this.titleDescriptionPanel.add(this.titleReview);
        this.titleDescriptionPanel.add(this.titleReviewBox);
        this.mailPanel.add(this.mailLabel);
        this.mailPanel.add(this.mailReview);
        this.reviewPanel.add(this.titleDescriptionPanel);
        this.reviewPanel.add(this.mailPanel);
        this.reviewPanel.add(this.description);
        this.buttonPanel.add(this.addFile);
        this.actionReviewPanel.add(this.send);
        this.actionReviewPanel.add(this.close);
        this.add(this.wishesTitle);
        this.add(this.wishesDescription);
        this.add(this.reviewPanel);
        this.add(this.buttonPanel);
        this.add(this.actionReviewPanel);
        this.add(this.deleteButtonsPanel);
        this.layout.putConstraint("West", (Component)this.wishesTitle, 270, "West", (Component)this);
        this.layout.putConstraint("North", (Component)this.wishesTitle, 10, "North", (Component)this);
        this.layout.putConstraint("West", (Component)this.wishesDescription, 10, "West", (Component)this);
        this.layout.putConstraint("North", (Component)this.wishesDescription, 10, "South", (Component)this.wishesTitle);
        this.layout.putConstraint("East", (Component)this.wishesDescription, -10, "East", (Component)this);
        this.layout.putConstraint("West", (Component)this.reviewPanel, 25, "West", (Component)this);
        this.layout.putConstraint("East", (Component)this.reviewPanel, -25, "East", (Component)this);
        this.layout.putConstraint("North", (Component)this.reviewPanel, 10, "South", (Component)this.wishesDescription);
        this.layout.putConstraint("West", (Component)this.buttonPanel, 10, "West", (Component)this);
        this.layout.putConstraint("North", (Component)this.buttonPanel, 0, "South", (Component)this.reviewPanel);
        this.layout.putConstraint("East", (Component)this.actionReviewPanel, -10, "East", (Component)this);
        this.layout.putConstraint("North", (Component)this.actionReviewPanel, 0, "South", (Component)this.reviewPanel);
        this.layout.putConstraint("West", (Component)this.deleteButtonsPanel, 10, "West", (Component)this);
        this.layout.putConstraint("North", (Component)this.deleteButtonsPanel, -5, "South", (Component)this.buttonPanel);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReviewWindowView.this.progressBar.setVisible(false);
                ReviewWindowView.this.controller.cancelSending();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReviewWindowView.this.parent.setEnabled(true);
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReviewWindowView.this.controller.setVisible(false);
            }
        });
        this.addFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFileChooser fileopen = new JFileChooser();
                        fileopen.setFileFilter(filter);
                        fileopen.setAcceptAllFileFilterUsed(false);
                        int ret = fileopen.showDialog(ReviewWindowView.this, Localizable.get().get("review.chooser.addFile"));
                        if (ret == 0) {
                            File file = fileopen.getSelectedFile();
                            ReviewWindowView.this.controller.addFileToSend(file);
                        }
                    }
                });
            }
        });
        this.send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Review review = new Review();
                        review.setTitle(ReviewWindowView.this.titleReview.getText());
                        review.setDescription(ReviewWindowView.this.description.getText());
                        review.setMailReview(ReviewWindowView.this.mailReview.getText());
                        int select = ReviewWindowView.this.titleReviewBox.getSelectedIndex();
                        review.setTypeReview(FolderEnum.values()[select].getName());
                        if (ValidateReview.validate(review)) {
                            ReviewWindowView.this.progressBar.setVisible(true);
                            ReviewWindowView.this.controller.sendFilesToServer(review);
                        }
                    }
                });
            }
        });
        this.description.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                ReviewWindowView.this.description.setForeground(Color.BLACK);
                ReviewWindowView.this.description.setText("");
                ReviewWindowView.this.description.removeFocusListener(this);
            }
        });
        this.pack();
    }

    public void addSendingFileView(String name) {
        DeleteButton deleteButton = new DeleteButton(name, this.addFile.getPreferredSize());
        this.deleteButtonsPanel.add(deleteButton);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReviewWindowView.this.deleteButtonsPanel.remove((DeleteButton)e.getSource());
                        ReviewWindowView.this.deleteButtonsPanel.revalidate();
                        ReviewWindowView.this.deleteButtonsPanel.repaint();
                        ReviewWindowView.this.controller.deleteFile(e.getActionCommand());
                    }
                });
            }
        });
        this.deleteButtonsPanel.revalidate();
        this.deleteButtonsPanel.repaint();
    }

    public void hideProgressBar() {
        this.progressBar.setVisible(false);
    }

    class DeleteButton
    extends JButton {
        public DeleteButton(String name, Dimension size) {
            this.setText(name);
            this.setHorizontalTextPosition(2);
            this.setIcon(new ImageIcon(this.getClass().getResource("/ru/turikhay/tlauncher/ui/images/Delete-24.png")));
            this.getMargin().right = 0;
            Dimension dim = new Dimension((int)this.getPreferredSize().getWidth(), (int)size.getHeight());
            if (dim.getWidth() > 150.0) {
                dim.width = 150;
            }
            this.setPreferredSize(dim);
        }
    }
}

