/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.core;

import java.util.ArrayList;
import javax.annotation.Nullable;
import naruto1310.craftableAnimals.core.CraftableAnimalsRegistry;
import naruto1310.craftableAnimals.core.ItemCraftableAnimalBase;
import naruto1310.craftableAnimals.core.SpawnEntity;
import naruto1310.craftableAnimals.vanilla.CAConfig;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCraftableAnimal
extends ItemCraftableAnimalBase {
    protected ResourceLocation animal;
    protected int types;
    protected int spawnAtLeastAtDifficulty;

    public ItemCraftableAnimal(ResourceLocation animal, int types, int difficulty) {
        this.func_77627_a(true);
        this.animal = animal;
        this.types = types;
        this.spawnAtLeastAtDifficulty = difficulty;
        CraftableAnimalsRegistry.addNameToItemMapping(animal, this);
        this.func_185043_a(new ResourceLocation("animalType"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ((ItemCraftableAnimal)stack.func_77973_b()).getType(stack);
            }
        });
    }

    public ItemCraftableAnimal setProperty(char key, int value) {
        CraftableAnimalsRegistry.getProperties(this).put(Character.valueOf(key), value);
        return this;
    }

    @Override
    public EntityLiving[] spawn(ItemStack stack, EntityPlayer player, World world, double x, double y, double z, EnumFacing side) {
        if (world.field_72995_K) {
            return null;
        }
        if (this.spawnAtLeastAtDifficulty > world.func_175659_aa().ordinal()) {
            if (CAConfig.showError && player != null) {
                player.func_145747_a((ITextComponent)new TextComponentString("To place this mob turn your difficulty up to " + (this.spawnAtLeastAtDifficulty == 1 ? "Easy" : (this.spawnAtLeastAtDifficulty == 2 ? "Normal" : "Hard")) + (this.spawnAtLeastAtDifficulty != 3 ? " or higher" : "") + "."));
            }
            return null;
        }
        EntityLiving entity = SpawnEntity.spawn(this.animal, world, x + (double)side.func_82601_c() + 0.5, y + (double)side.func_96559_d(), z + (double)side.func_82599_e() + 0.5, player, stack.func_77952_i());
        if (stack.func_82837_s() && entity != null) {
            entity.func_96094_a(stack.func_82833_r());
        }
        return new EntityLiving[]{entity};
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < Math.max(this.types, 1); ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public final ResourceLocation getAnimal() {
        return this.animal;
    }

    @Override
    public EntityLiving[] createEntity(ItemStack stack, World world) {
        EntityLiving entity = SpawnEntity.getEntityForRender(this.getAnimal(stack), world, this.getType(stack));
        ArrayList<EntityLiving> ret = new ArrayList<EntityLiving>();
        ret.add(entity);
        while (entity.func_184188_bt().size() != 0) {
            entity = (EntityLiving)entity.func_184188_bt().get(0);
            ret.add(entity);
        }
        return ret.toArray(new EntityLiving[ret.size()]);
    }

    @Override
    public ResourceLocation getAnimal(ItemStack stack) {
        return ((ItemCraftableAnimal)stack.func_77973_b()).getAnimal();
    }

    @Override
    public int getType(ItemStack stack) {
        return stack.func_77952_i();
    }

    public int getTypes() {
        return this.types;
    }

    @Override
    public ItemCraftableAnimal getItem(ItemStack stack) {
        return this;
    }
}

