/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.core;

import java.lang.reflect.Field;
import java.util.Map;
import naruto1310.craftableAnimals.core.CraftableAnimalsRegistry;
import naruto1310.craftableAnimals.core.ICraftableAnimal;
import naruto1310.craftableAnimals.core.ItemCraftableAnimal;
import naruto1310.craftableAnimals.core.ModelBipedArmor;
import naruto1310.craftableAnimals.core.SpawnEntity;
import naruto1310.craftableAnimals.vanilla.CAConfig;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemCraftableAnimalBase
extends ItemArmor
implements ICraftableAnimal,
IBehaviorDispenseItem {
    private static Object modelBipedArmor = null;

    public ItemCraftableAnimalBase() {
        super(ItemArmor.ArmorMaterial.valueOf((String)"craftableAnimal"), 0, EntityEquipmentSlot.HEAD);
        this.func_77656_e(0);
        this.func_77625_d(CAConfig.maxStackSize);
        try {
            for (Field f : RegistrySimple.class.getDeclaredFields()) {
                if (f.getType() != Map.class) continue;
                f.setAccessible(true);
                ((Map)f.get(BlockDispenser.field_149943_a)).remove(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)this);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float facing, float hitX, float hitY) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150474_ac) {
            if (!world.field_72995_K && ((ICraftableAnimal)stack.func_77973_b()).canUse(stack, world, player)) {
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(pos);
                MobSpawnerBaseLogic logic = spawner.func_145881_a();
                EntityLiving e = CraftableAnimalsRegistry.createEntity(stack, world)[0];
                NBTTagCompound nbt = new NBTTagCompound();
                logic.func_189530_b(nbt);
                NBTTagCompound spawnData = new NBTTagCompound();
                e.func_189511_e(spawnData);
                spawnData.func_82580_o("Pos");
                spawnData.func_82580_o("Rotation");
                spawnData.func_82580_o("Motion");
                spawnData.func_74778_a("id", SpawnEntity.getNameFromEntity(e).toString());
                nbt.func_74782_a("SpawnData", (NBTBase)spawnData);
                logic.func_98270_a(nbt);
                spawner.func_70296_d();
                world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (!world.field_72995_K && ((ICraftableAnimal)stack.func_77973_b()).canUse(stack, world, player)) {
            ((ICraftableAnimal)stack.func_77973_b()).spawn(stack, player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side);
            ((ICraftableAnimal)stack.func_77973_b()).use(stack, world, player);
        }
        return EnumActionResult.SUCCESS;
    }

    public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        EnumFacing enumfacing = (EnumFacing)source.func_82618_k().func_180495_p(source.func_180699_d()).func_177229_b((IProperty)BlockDispenser.field_176441_a);
        double d0 = source.func_82615_a() + (double)enumfacing.func_82601_c();
        double d1 = source.func_82617_b() + (double)enumfacing.func_96559_d();
        double d2 = source.func_82616_c() + (double)enumfacing.func_82599_e();
        SpawnEntity.spawn(((ItemCraftableAnimal)stack.func_77973_b()).getAnimal(), source.func_82618_k(), d0, d1, d2, null, stack.func_77952_i());
        stack.func_190917_f(-1);
        return stack;
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        World world = player.field_70170_p;
        Entity target = event.getTarget();
        if (stack == null || !(stack.func_77973_b() instanceof ICraftableAnimal) || target.func_184188_bt().size() != 0 || !((ICraftableAnimal)stack.func_77973_b()).canUse(stack, world, player) || player.func_70093_af()) {
            return;
        }
        if (target instanceof EntityMinecartMobSpawner) {
            EntityLiving[] entity = ((ICraftableAnimal)stack.func_77973_b()).createEntity(stack, world);
            if (entity == null) {
                return;
            }
            EntityMinecartMobSpawner spawner = (EntityMinecartMobSpawner)target;
            int e = entity.length - 1;
            Field m = null;
            for (Field f : EntityMinecartMobSpawner.class.getDeclaredFields()) {
                if (f.getType() != MobSpawnerBaseLogic.class) continue;
                f.setAccessible(true);
                m = f;
            }
            MobSpawnerBaseLogic logic = null;
            try {
                logic = (MobSpawnerBaseLogic)m.get(spawner);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            logic.func_190894_a(EntityList.func_191306_a(entity[e].getClass()));
            NBTTagCompound nbt = new NBTTagCompound();
            spawner.func_189511_e(nbt);
            nbt.func_82580_o("SpawnData");
            nbt.func_82580_o("SpawnPotentials");
            NBTTagCompound data = new NBTTagCompound();
            entity[e].func_189511_e(data);
            data.func_82580_o("Pos");
            data.func_82580_o("Rotation");
            data.func_82580_o("Motion");
            nbt.func_74778_a("EntityId", EntityList.func_75621_b((Entity)entity[e]));
            nbt.func_74778_a("id", "Cow");
            nbt.func_74782_a("SpawnData", (NBTBase)data);
            spawner.func_70020_e(nbt);
            ((ICraftableAnimal)stack.func_77973_b()).use(stack, world, player);
            event.setCanceled(true);
        }
        if (target instanceof EntityLiving && !world.field_72995_K) {
            EntityLiving[] spawned = ((ICraftableAnimal)stack.func_77973_b()).createEntity(stack, world);
            spawned[0].func_70012_b(event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v, 0.0f, 0.0f);
            spawned[0].func_184220_m(target);
            for (EntityLiving entity : spawned) {
                world.func_72838_d((Entity)entity);
            }
            ((ICraftableAnimal)stack.func_77973_b()).use(stack, world, player);
            event.setCanceled(true);
        }
    }

    @Override
    public boolean canUse(ItemStack stack, World world, EntityPlayer player) {
        return true;
    }

    @Override
    public void use(ItemStack stack, World world, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190920_e(stack.func_190916_E() - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped def) {
        if (armorSlot == EntityEquipmentSlot.HEAD) {
            if (modelBipedArmor == null) {
                modelBipedArmor = new ModelBipedArmor();
            }
            return (ModelBiped)modelBipedArmor;
        }
        return def;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "craftableanimals:textures/models/armor/craftableAnimal.png";
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public abstract ItemCraftableAnimal getItem(ItemStack var1);
}

