/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.core;

import naruto1310.craftableAnimals.core.AbstractCraftableAnimalsExtension;
import naruto1310.craftableAnimals.core.CraftableAnimalsRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class SpawnEntity {
    public static ResourceLocation getNameFromEntity(EntityLiving entity) {
        return EntityList.func_191306_a(entity.getClass());
    }

    public static EntityLiving createEntityByName(ResourceLocation name, World world) {
        return (EntityLiving)EntityList.func_188429_b((ResourceLocation)name, (World)world);
    }

    public static EntityLiving spawn(ResourceLocation name, World world, double x, double y, double z, EntityPlayer player, int type) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!extension.isHandler(name)) continue;
            EntityLiving entity = extension.overwriteSpawn(name, world, x, y, z, player, type);
            if (entity != null) {
                return entity;
            }
            entity = extension.modifyEntity(extension.create(name, world), world, player, type);
            if (entity == null) {
                String s = "Could not spawn \"" + name + "\".";
                player.func_145747_a((ITextComponent)new TextComponentString(s));
                new NullPointerException(s).printStackTrace();
                return null;
            }
            entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat(), 0.0f);
            world.func_72838_d((Entity)entity);
            return entity;
        }
        EntityLiving entity = SpawnEntity.createEntityByName(name, world);
        entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat(), 0.0f);
        world.func_72838_d((Entity)entity);
        return entity;
    }

    public static EntityLiving getEntityForRender(ResourceLocation name, World world, int type) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!extension.isHandler(name)) continue;
            EntityLiving entity = extension.overwriteSpawn(name, world, 0.0, 0.0, 0.0, null, type);
            if (entity != null) {
                return entity;
            }
            return extension.modifyEntity(extension.create(name, world), world, null, type);
        }
        return SpawnEntity.createEntityByName(name, world);
    }

    public static int getTypeFromEntity(EntityLiving entity) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!extension.isHandler(SpawnEntity.getNameFromEntity(entity))) continue;
            return extension.getTypeFromEntity(entity);
        }
        return 0;
    }

    public static EntityLiving setAdult(EntityLiving entity, boolean adult) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!extension.isHandler(SpawnEntity.getNameFromEntity(entity))) continue;
            return extension.setAdult(entity, adult);
        }
        return null;
    }

    public static boolean isSpawnable(ResourceLocation name) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!extension.isHandler(name)) continue;
            return true;
        }
        return false;
    }
}

