/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import naruto1310.craftableAnimals.vanilla.CAFMLPlugin;

public class CAConfig {
    public static boolean showError = true;
    public static int giantSlimeSize = 8;
    public static int chanceOfDrop = 1;
    public static int minimizerTime = 80;
    public static boolean safeEnder = true;
    public static boolean removeEggs = true;
    public static boolean useCoremod = true;
    public static int ownCreativeTab = 2;
    public static int maxStackSize = 16;
    public static int updateCheck = 2;
    public static boolean shiftClickArmor = true;
    public static boolean serverMode = false;
    private static Map<String, String> values;
    private static boolean changed;

    public static void init(File f) {
        CAConfig.load(f);
        try {
            giantSlimeSize = Integer.valueOf(CAConfig.getOrCreateValue("GiantSlimeSize", giantSlimeSize, "The size of giant slime and magma cube. Default: " + giantSlimeSize));
            chanceOfDrop = Integer.valueOf(CAConfig.getOrCreateValue("chanceOfDrop", chanceOfDrop, "Out of 100 dying animals how many will drop themselves as an item. Default: " + chanceOfDrop));
            minimizerTime = Integer.valueOf(CAConfig.getOrCreateValue("minimizerTime", minimizerTime, "The number of milliseconds each frame of the minimizer animation will be shown (0 = still image). Default: " + minimizerTime));
            maxStackSize = Integer.valueOf(CAConfig.getOrCreateValue("maxStackSize", maxStackSize, "The maximal size of animal stacks. Default: " + maxStackSize));
            showError = Boolean.valueOf(CAConfig.getOrCreateValue("showError", showError, "Show a error message when trying to place an animal at to low difficulty. Default: " + showError));
            ownCreativeTab = Integer.valueOf(CAConfig.getOrCreateValue("ownCreativeTab", ownCreativeTab, "(Client only) Use seperate creativ tab. 0 = off, 1 = animals only, 2 = everything. Default: " + ownCreativeTab));
            safeEnder = Boolean.valueOf(CAConfig.getOrCreateValue("safeEnder", safeEnder, "Safety check before spawning an ender dragon. Default: " + safeEnder));
            removeEggs = Boolean.valueOf(CAConfig.getOrCreateValue("removeEggs", removeEggs, "Remove spawn eggs. Default: " + removeEggs));
            useCoremod = Boolean.valueOf(CAConfig.getOrCreateValue("useCoremod", useCoremod, "Use FML coremod features. Setting this to false will remove some features, but potentally fix bugs. Default: " + useCoremod));
            updateCheck = Integer.valueOf(CAConfig.getOrCreateValue("updateCheck", updateCheck, "(Client only) Check online for new version. 0 = off, 1 = check manually, 2 = check automatically and alert. Default: " + updateCheck));
            serverMode = Boolean.valueOf(CAConfig.getOrCreateValue("serverMode", serverMode, "Disable Enderdragen, Wither Boss and Giant. Usefull to protect servers from griefers. Players who try to craft these mobs, without having this option enabled will crash their game, but not the server. Default: " + serverMode));
            shiftClickArmor = Boolean.valueOf(CAConfig.getOrCreateValue("shiftClickArmor", shiftClickArmor, "Shift click armor on mobs. Default: " + shiftClickArmor));
            CAFMLPlugin.loadedConfig = true;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        CAConfig.save(f);
    }

    public static void load(File file) {
        values = new TreeMap<String, String>();
        try {
            Scanner scan = new Scanner(file);
            while (scan.hasNext()) {
                String s = scan.nextLine();
                if (s.startsWith("#") || s.isEmpty()) continue;
                if (s.contains("=")) {
                    s = s.replace(" ", "");
                    values.put(s.substring(0, s.indexOf("=")), s.substring(s.indexOf("=") + 1, s.length()));
                    continue;
                }
                CAFMLPlugin.log.info("CraftableAnimals config found unexpected line: " + s);
            }
            scan.close();
        }
        catch (FileNotFoundException e) {
            CAFMLPlugin.log.info("CraftableAnimals could not find config. Generating one.");
        }
    }

    public static void save(File file) {
        if (!changed) {
            return;
        }
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(file));
            output.write("# CraftableAnimals configuration file");
            output.newLine();
            output.write("#          mod by Naruto1310         ");
            output.newLine();
            for (int i = 0; i < values.size(); ++i) {
                String value = values.values().toArray()[i].toString();
                if (value.contains(":")) {
                    output.newLine();
                    output.write("# " + value.substring(value.indexOf(":") + 1));
                    output.newLine();
                    value = value.substring(0, value.indexOf(":"));
                }
                output.write(values.keySet().toArray()[i] + " = " + value);
                output.newLine();
            }
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getOrCreateValue(String key, Object defaultValue, String comment) {
        if (!values.containsKey(key)) {
            values.put(key, defaultValue.toString());
            changed = true;
        }
        if (comment != null) {
            String value = values.get(key);
            if (!value.contentEquals(defaultValue.toString())) {
                changed = true;
            }
            values.put(key, value + ":" + comment);
            return value;
        }
        return values.get(key);
    }

    public static String getOrCreateValue(String key, String defaultValue) {
        return CAConfig.getOrCreateValue(key, defaultValue, null);
    }

    static {
        changed = false;
    }
}

