/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import naruto1310.craftableAnimals.core.CraftableAnimalsRegistry;
import naruto1310.craftableAnimals.core.ItemCraftableAnimal;
import naruto1310.craftableAnimals.core.SpawnEntity;
import naruto1310.craftableAnimals.vanilla.CACommonProxy;
import naruto1310.craftableAnimals.vanilla.CAConfig;
import naruto1310.craftableAnimals.vanilla.CAFMLPlugin;
import naruto1310.craftableAnimals.vanilla.CARecipes;
import naruto1310.craftableAnimals.vanilla.CAVanillaExtension;
import naruto1310.craftableAnimals.vanilla.block.BlockAnimalDisplay;
import naruto1310.craftableAnimals.vanilla.block.BlockEmptySpawner;
import naruto1310.craftableAnimals.vanilla.block.TileEntityAnimalDisplay;
import naruto1310.craftableAnimals.vanilla.item.EntityAnimalArrow;
import naruto1310.craftableAnimals.vanilla.item.ItemAnimalArmored;
import naruto1310.craftableAnimals.vanilla.item.ItemAnimalArmorer;
import naruto1310.craftableAnimals.vanilla.item.ItemAnimalBow;
import naruto1310.craftableAnimals.vanilla.item.ItemAnimalSoul;
import naruto1310.craftableAnimals.vanilla.item.ItemBabyAnimal;
import naruto1310.craftableAnimals.vanilla.item.ItemCraftableVanillaAnimal;
import naruto1310.craftableAnimals.vanilla.item.ItemEnderCrystal;
import naruto1310.craftableAnimals.vanilla.item.ItemGuideBook;
import naruto1310.craftableAnimals.vanilla.item.ItemMinimizer;
import naruto1310.craftableAnimals.vanilla.packet.DisplaySync;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(modid="craftableanimals", name="Craftable Animals", version="2.7.0", acceptedMinecraftVersions="[1.11]")
public class CraftableAnimals {
    public static final String version = "2.7.0";
    public static String latestVersion = "<not checked>";
    public static boolean isLatestVersion = true;
    public static ItemCraftableAnimal snowgolem;
    public static ItemCraftableAnimal irongolem;
    public static ItemCraftableAnimal bat;
    public static ItemCraftableAnimal chicken;
    public static ItemCraftableAnimal cow;
    public static ItemCraftableAnimal horse;
    public static ItemCraftableAnimal horse_donkey;
    public static ItemCraftableAnimal horse_mule;
    public static ItemCraftableAnimal horse_skeleton;
    public static ItemCraftableAnimal horse_zombie;
    public static ItemCraftableAnimal mooshroom;
    public static ItemCraftableAnimal ocelot;
    public static ItemCraftableAnimal pig;
    public static ItemCraftableAnimal rabbit;
    public static ItemCraftableAnimal sheep;
    public static ItemCraftableAnimal squid;
    public static ItemCraftableAnimal villager;
    public static ItemCraftableAnimal enderman;
    public static ItemCraftableAnimal llama;
    public static ItemCraftableAnimal polarbear;
    public static ItemCraftableAnimal wolf;
    public static ItemCraftableAnimal zombiepig;
    public static ItemCraftableAnimal blaze;
    public static ItemCraftableAnimal cavespider;
    public static ItemCraftableAnimal creeper;
    public static ItemCraftableAnimal endermite;
    public static ItemCraftableAnimal evoker;
    public static ItemCraftableAnimal ghast;
    public static ItemCraftableAnimal guardian;
    public static ItemCraftableAnimal guardian_elder;
    public static ItemCraftableAnimal magmacube;
    public static ItemCraftableAnimal shulker;
    public static ItemCraftableAnimal silverfish;
    public static ItemCraftableAnimal skeleton;
    public static ItemCraftableAnimal skeleton_wither;
    public static ItemCraftableAnimal skeleton_stray;
    public static ItemCraftableAnimal slime;
    public static ItemCraftableAnimal spider;
    public static ItemCraftableAnimal jockey;
    public static ItemCraftableAnimal vex;
    public static ItemCraftableAnimal vindicator;
    public static ItemCraftableAnimal witch;
    public static ItemCraftableAnimal zombie;
    public static ItemCraftableAnimal zombie_villager;
    public static ItemCraftableAnimal zombie_husk;
    public static ItemCraftableAnimal enderdragon;
    public static ItemCraftableAnimal giant;
    public static ItemCraftableAnimal wither;
    public static ItemEnderCrystal crystal;
    public static ItemMinimizer minimizer;
    public static ItemAnimalBow animalbow;
    public static ItemBabyAnimal baby;
    public static ItemAnimalSoul soul;
    public static ItemMinecart minecart;
    public static ItemAnimalArmorer armorer;
    public static ItemAnimalArmored armored;
    public static ItemGuideBook guide;
    public static BlockEmptySpawner spawner;
    public static BlockAnimalDisplay display;
    public static ItemBlock display_item;
    public static ItemBlock spawner_item;
    @SidedProxy(clientSide="naruto1310.craftableAnimals.vanilla.CAClientProxy", serverSide="naruto1310.craftableAnimals.vanilla.CACommonProxy")
    public static CACommonProxy proxy;
    @Mod.Instance(value="craftableanimals")
    public static CraftableAnimals instance;
    public static CreativeTabs tab;
    public static ItemStack creativTabItem;
    public static final Map<IRecipe, List<IRecipe>> recipes;
    private static Field fieldActivatingRangeFromPlayer;
    private boolean worldLoaded = false;

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (!CAFMLPlugin.loadedConfig) {
            throw new RuntimeException("[CraftableAnimals]FMLPlugin was not loaded. Cannot continue loading.");
        }
        if (CAConfig.serverMode) {
            System.out.println("[CraftableAnimals]Running in server mode.");
        }
        this.initRecipes();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)soul);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        GameRegistry.registerTileEntity(TileEntityAnimalDisplay.class, (String)"animalDisplay");
        DisplaySync.initNetwork();
        proxy.init();
        CraftableAnimalsRegistry.registerExtension(new CAVanillaExtension());
        if (CAConfig.updateCheck == 2) {
            CraftableAnimals.checkVersion();
        }
    }

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        proxy.preInitBegin();
        if (CAConfig.ownCreativeTab != 0) {
            tab = new CreativeTabs("tabCraftableAnimals"){

                public ItemStack func_151244_d() {
                    return creativTabItem;
                }

                public ItemStack func_78016_d() {
                    return ItemStack.field_190927_a;
                }
            };
        }
        this.initItems();
        if (CAConfig.ownCreativeTab != 0) {
            ItemCraftableVanillaAnimal item;
            Random r = new Random();
            creativTabItem = new ItemStack((Item)item, 1, (item = (ItemCraftableVanillaAnimal)CraftableAnimalsRegistry.getNameToItemMap().values().toArray()[r.nextInt(CraftableAnimalsRegistry.getNameToItemMap().size())]).getTypes() == 0 ? 0 : r.nextInt(item.getTypes()));
            if (r.nextInt(1000) == 0) {
                creativTabItem.func_77982_d(new NBTTagCompound());
                creativTabItem.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
            }
        }
        proxy.preInitEnd();
    }

    private void initItems() {
        CraftableAnimalsRegistry.init();
        snowgolem = proxy.createItem("SnowMan", 1, 0).setProperty('a', 1);
        irongolem = proxy.createItem("VillagerGolem", 1, 0).setProperty('a', 1);
        bat = proxy.createItem("Bat", 1, 0);
        chicken = proxy.createItem("Chicken", 1, 0).setProperty('b', 1);
        cow = proxy.createItem("Cow", 1, 0).setProperty('b', 1).setProperty('a', 9);
        horse = proxy.createItem("EntityHorse", 34, 0).setProperty('b', 1);
        horse_donkey = proxy.createItem("Donkey", 1, 0).setProperty('b', 1);
        horse_mule = proxy.createItem("Mule", 1, 0).setProperty('b', 1);
        horse_skeleton = proxy.createItem("SkeletonHorse", 1, 0).setProperty('b', 1);
        horse_zombie = proxy.createItem("ZombieHorse", 1, 0).setProperty('b', 1);
        mooshroom = proxy.createItem("MushroomCow", 1, 0).setProperty('b', 1).setProperty('a', 9);
        ocelot = proxy.createItem("Ozelot", 4, 0).setProperty('b', 1);
        pig = proxy.createItem("Pig", 2, 0).setProperty('b', 1).setProperty('a', 9);
        rabbit = proxy.createItem("Rabbit", 7, 0).setProperty('b', 1);
        sheep = proxy.createItem("Sheep", 17, 0).setProperty('b', 1).setProperty('a', 9);
        squid = proxy.createItem("Squid", 1, 0).setProperty('a', 9);
        villager = proxy.createItem("Villager", 5, 0).setProperty('b', 1);
        enderman = proxy.createItem("Enderman", 1, 1).setProperty('a', 9);
        llama = proxy.createItem("Llama", 4, 0).setProperty('b', 1);
        polarbear = proxy.createItem("PolarBear", 1, 0).setProperty('b', 1);
        wolf = proxy.createItem("Wolf", 3, 0).setProperty('b', 1);
        zombiepig = proxy.createItem("PigZombie", 1, 1).setProperty('a', 31);
        blaze = proxy.createItem("Blaze", 1, 1).setProperty('a', 9);
        cavespider = proxy.createItem("CaveSpider", 1, 1).setProperty('a', 9);
        creeper = proxy.createItem("Creeper", 2, 1).setProperty('a', 9);
        endermite = proxy.createItem("Endermite", 1, 1);
        evoker = proxy.createItem("EvocationIllager", 1, 1);
        ghast = proxy.createItem("Ghast", 1, 1).setProperty('a', 9);
        guardian = proxy.createItem("Guardian", 1, 1);
        guardian_elder = proxy.createItem("ElderGuardian", 1, 1);
        magmacube = proxy.createItem("LavaSlime", 4, 1).setProperty('a', 1);
        shulker = proxy.createItem("Shulker", 1, 1);
        silverfish = proxy.createItem("Silverfish", 1, 1);
        skeleton = proxy.createItem("Skeleton", 1, 1).setProperty('a', 31);
        skeleton_wither = proxy.createItem("WitherSkeleton", 1, 1).setProperty('a', 31);
        skeleton_stray = proxy.createItem("Stray", 1, 1).setProperty('a', 31);
        slime = proxy.createItem("Slime", 5, 1).setProperty('a', 1);
        spider = proxy.createItem("Spider", 1, 1).setProperty('a', 9);
        jockey = proxy.createItem("Jockey", 18, 1);
        vex = proxy.createItem("Vex", 1, 1);
        vindicator = proxy.createItem("VindicationIllager", 1, 1);
        witch = proxy.createItem("Witch", 1, 1);
        zombie = proxy.createItem("Zombie", 1, 1).setProperty('b', 1).setProperty('a', 31);
        zombie_villager = proxy.createItem("ZombieVillager", 5, 1).setProperty('b', 1).setProperty('a', 31);
        zombie_husk = proxy.createItem("Husk", 1, 1).setProperty('b', 1).setProperty('a', 31);
        if (!CAConfig.serverMode) {
            enderdragon = proxy.createItem("EnderDragon", 1, 1);
            giant = proxy.createItem("Giant", 1, 1).setProperty('a', 31);
            wither = proxy.createItem("WitherBoss", 1, 1);
        }
        crystal = proxy.registerItem(new ItemEnderCrystal(), "crystal", true);
        minimizer = proxy.registerItem(new ItemMinimizer(), "minimizer", true);
        animalbow = proxy.registerItem(new ItemAnimalBow(), "bow", true);
        baby = proxy.registerItem(new ItemBabyAnimal(), "baby", false);
        soul = proxy.registerItem(new ItemAnimalSoul(), "soul", false);
        minecart = proxy.registerItem(new ItemMinecart(EntityMinecart.Type.SPAWNER), "minecart", true);
        armorer = proxy.registerItem(new ItemAnimalArmorer(), "armorer", true);
        armored = proxy.registerItem(new ItemAnimalArmored(), "armored", false);
        guide = proxy.registerItem(new ItemGuideBook(), "guide", true);
        animalbow.func_77664_n();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("craftableanimals:animalarrow"), EntityAnimalArrow.class, (String)"animalarrow", (int)0, (Object)this, (int)64, (int)20, (boolean)true);
        spawner = (BlockEmptySpawner)new BlockEmptySpawner().func_149663_c("craftableAnimals.spawner").func_149711_c(5.0f).setRegistryName("craftableanimals:spawner");
        display = (BlockAnimalDisplay)new BlockAnimalDisplay().func_149663_c("craftableAnimals.display").func_149711_c(0.3f).setRegistryName("craftableanimals:display");
        GameRegistry.register((IForgeRegistryEntry)spawner);
        GameRegistry.register((IForgeRegistryEntry)display);
        spawner.setHarvestLevel("pickaxe", 2);
        display_item = proxy.registerItem(new ItemBlock((Block)display), "display", true);
        spawner_item = proxy.registerItem(new ItemBlock((Block)spawner), "spawner", true);
        try {
            Method hide = Class.forName("codechicken.nei.api.API").getMethod("hideItem", ItemStack.class);
            hide.invoke(null, new ItemStack((Item)baby));
            hide.invoke(null, new ItemStack((Item)armored));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private void initRecipes() {
        int i;
        ItemStack[] cloth = new ItemStack[16];
        for (i = 0; i < 16; ++i) {
            cloth[i] = new ItemStack(Blocks.field_150325_L, 1, i);
        }
        CraftableAnimals.addRecipe(0, new ItemStack((Item)snowgolem, 1), "X", "Y", "Y", Character.valueOf('X'), Blocks.field_150423_aK, Character.valueOf('Y'), Blocks.field_150433_aE);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)irongolem, 1), " X ", "YYY", " Y ", Character.valueOf('X'), Blocks.field_150423_aK, Character.valueOf('Y'), Blocks.field_150339_S);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)bat, 2), "X", "Y", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Items.field_151147_al);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)chicken, 3), "XXX", "YYY", "XXX", Character.valueOf('X'), Items.field_151008_G, Character.valueOf('Y'), Items.field_151076_bf);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)chicken, 1), "XXX", "XXX", "XXX", Character.valueOf('X'), Items.field_151110_aK);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)cow, 2), "XYX", "YYY", "XYX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), Items.field_151082_bd);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)horse, 2, 0), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 1), "X  ", "XYX", "XZX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[0], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 2), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[0], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 3), "X Z", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[0], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 4), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[0], Character.valueOf('Z'), cloth[15]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 5), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[4]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 6), "X  ", "XYX", "XZX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[4], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 7), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[4], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 8), "X Z", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[4], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 9), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[4], Character.valueOf('Z'), cloth[15]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 10), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[1]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 11), "X  ", "XYX", "XZX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[1], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 12), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[1], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 13), "X Z", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[1], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 14), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[1], Character.valueOf('Z'), cloth[15]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 15), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[14]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 16), "X  ", "XYX", "XZX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[14], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 17), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[14], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 18), "X Z", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[14], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 19), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[14], Character.valueOf('Z'), cloth[15]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 20), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[15]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 21), "X  ", "XYX", "XZX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[15], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 22), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[15], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 23), "X Z", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[15], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 24), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[15], Character.valueOf('Z'), cloth[15]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 25), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[7]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 26), "X  ", "XYX", "XZX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[7], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 27), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[7], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 28), "X Z", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[7], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 29), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[7], Character.valueOf('Z'), cloth[15]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 30), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[12]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 31), "X  ", "XYX", "XZX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[12], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 32), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[12], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 33), "X Z", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[12], Character.valueOf('Z'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse, 2, 34), "XZ ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[12], Character.valueOf('Z'), cloth[15]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse_donkey, 2), "X  ", "XXY", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[8]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse_mule, 2), "X  ", "XXY", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[12]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse_skeleton, 2), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), Items.field_151103_aS);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)horse_zombie, 2), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), Items.field_151078_bh);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)mooshroom, 1), "XXX", "XYX", "XXX", Character.valueOf('X'), Blocks.field_150337_Q, Character.valueOf('Y'), cow);
        CraftableAnimals.addRecipe(1, new ItemStack((Item)ocelot, 1), Blocks.field_150325_L, Items.field_151147_al);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)ocelot, 1, 1), Items.field_151115_aP, ocelot, cloth[15]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)ocelot, 1, 2), Items.field_151115_aP, ocelot, cloth[1]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)ocelot, 1, 2), Items.field_151115_aP, ocelot, cloth[4]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)ocelot, 1, 2), Items.field_151115_aP, ocelot, cloth[14]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)ocelot, 1, 3), Items.field_151115_aP, ocelot, cloth[0], cloth[15]);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)pig, 4, 0), "XXX", "X X", "XXX", Character.valueOf('X'), Items.field_151147_al);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)pig, 1, 1), Items.field_151141_av, new ItemStack((Item)pig, 1, 0));
        CraftableAnimals.addRecipe(1, new ItemStack((Item)rabbit, 1, 0), Items.field_179555_bs, Items.field_179558_bo, cloth[12]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)rabbit, 1, 1), Items.field_179555_bs, Items.field_179558_bo, cloth[0]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)rabbit, 1, 2), Items.field_179555_bs, Items.field_179558_bo, cloth[15]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)rabbit, 1, 3), Items.field_179555_bs, Items.field_179558_bo, cloth[0], cloth[15]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)rabbit, 1, 4), Items.field_179555_bs, Items.field_179558_bo, cloth[4]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)rabbit, 1, 5), Items.field_179555_bs, Items.field_179558_bo, cloth[0], cloth[12]);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)rabbit, 1, 6), rabbit, Items.field_151041_m);
        for (i = 0; i < 16; ++i) {
            CraftableAnimals.addRecipe(i == 0 ? 0 : 2, new ItemStack((Item)sheep, 2, i), "XXX", "YYY", "XXX", Character.valueOf('X'), cloth[i], Character.valueOf('Y'), Items.field_179561_bm);
            CraftableAnimals.addRecipe(2, new ItemStack((Item)sheep, 2, i), "XXX", "XYX", "XXX", Character.valueOf('X'), cloth[i], Character.valueOf('Y'), Items.field_179561_bm);
            CraftableAnimals.addRecipe(3, new ItemStack((Item)sheep, 1, i), sheep, new ItemStack(Items.field_151100_aR, 1, 15 - i));
        }
        CraftableAnimals.addRecipe(3, new ItemStack((Item)sheep, 1, 16), sheep);
        CraftableAnimals.addRecipe(4, new ItemStack((Item)sheep, 2), "XXX", "YYY", "XXX", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), Items.field_179561_bm);
        CraftableAnimals.addRecipe(4, new ItemStack((Item)sheep, 2), "XXX", "XYX", "XXX", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), Items.field_179561_bm);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)squid, 2), "XXX", "X X", "XXX", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 0));
        CraftableAnimals.addRecipe(0, new ItemStack((Item)villager, 2, 0), "XXX", "YYY", Character.valueOf('X'), Items.field_151015_O, Character.valueOf('Y'), Blocks.field_150346_d);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)villager, 2, 1), "XXX", "XYX", "XXX", Character.valueOf('X'), Items.field_151122_aG, Character.valueOf('Y'), Blocks.field_150342_X);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)villager, 1, 2), " X ", "XXX", " X ", Character.valueOf('X'), Items.field_151055_y);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)villager, 2, 3), "X", "Y", "Z", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), Blocks.field_150460_al, Character.valueOf('Z'), Items.field_151044_h);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)villager, 3, 3), "X", "Y", "Z", Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), Blocks.field_150460_al, Character.valueOf('Z'), Items.field_151044_h);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)villager, 2, 4), Items.field_151049_t, new ItemStack((Item)pig, 1, 0));
        CraftableAnimals.addRecipe(3, new ItemStack((Item)villager, 2, 4), Items.field_151006_E, new ItemStack((Item)pig, 1, 0));
        CraftableAnimals.addRecipe(3, new ItemStack((Item)villager, 3, 4), Items.field_151036_c, new ItemStack((Item)pig, 1, 0));
        CraftableAnimals.addRecipe(3, new ItemStack((Item)villager, 4, 4), Items.field_151056_x, new ItemStack((Item)pig, 1, 0));
        CraftableAnimals.addRecipe(0, new ItemStack((Item)enderman, 8), "XXX", "X X", "XXX", Character.valueOf('X'), Items.field_151079_bi);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)llama, 3, 0), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[4]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)llama, 3, 1), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[0]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)llama, 3, 2), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[12]);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)llama, 3, 3), "X  ", "XYX", "X X", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), cloth[8]);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)polarbear, 1), " X ", "XYX", Character.valueOf('X'), new ItemStack(Items.field_151115_aP, 1, 0), Character.valueOf('Y'), new ItemStack(Items.field_151115_aP, 1, 1));
        CraftableAnimals.addRecipe(0, new ItemStack((Item)wolf, 2), "X X", " Y ", "X X", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), sheep);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)wolf, 1, 1), " X ", "XYX", " X ", Character.valueOf('X'), Items.field_151103_aS, Character.valueOf('Y'), new ItemStack((Item)wolf, 1, 0));
        CraftableAnimals.addRecipe(2, new ItemStack((Item)wolf, 2, 1), "XZX", "ZYZ", "XZX", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), sheep, Character.valueOf('Z'), Items.field_151103_aS);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)wolf, 1, 2), "XYX", Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), new ItemStack((Item)wolf, 1, 0));
        CraftableAnimals.addRecipe(2, new ItemStack((Item)wolf, 2, 2), "X X", "ZYZ", "X X", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), sheep, Character.valueOf('Z'), Items.field_151016_H);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)zombiepig, 4), "XYX", "YZY", "XYX", Character.valueOf('X'), Items.field_151078_bh, Character.valueOf('Y'), Items.field_151074_bl, Character.valueOf('Z'), Items.field_151010_B);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)blaze, 8), "XXX", "XZX", "XXX", Character.valueOf('X'), Items.field_151072_bj, Character.valueOf('Y'), Items.field_151033_d);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)cavespider, 4), "XYX", "YZY", "XYX", Character.valueOf('X'), Items.field_151007_F, Character.valueOf('Y'), Items.field_151070_bp, Character.valueOf('Z'), Items.field_151078_bh);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)creeper, 4), "XXX", "XYX", "XXX", Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), Items.field_151078_bh);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)creeper, 1, 1), " X ", "XYX", " X ", Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), new ItemStack((Item)creeper, 1, 0));
        CraftableAnimals.addRecipe(1, new ItemStack((Item)endermite, 4), enderman);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)endermite, 4), " X ", "XYX", " X ", Character.valueOf('X'), silverfish, Character.valueOf('Y'), Items.field_151079_bi);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)evoker, 1), " X", "YX", " X", Character.valueOf('X'), Items.field_151166_bC, Character.valueOf('Y'), Items.field_190929_cY);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)ghast, 3), "XXX", "YYY", "XXX", Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), Items.field_151073_bk);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)guardian, 1), "X ", "YZ", "X ", Character.valueOf('X'), Items.field_179562_cC, Character.valueOf('Y'), Items.field_179563_cD, Character.valueOf('Z'), Items.field_151115_aP);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)guardian_elder, 1), "X  ", "YZA", "X  ", Character.valueOf('X'), Items.field_179562_cC, Character.valueOf('Y'), new ItemStack(Blocks.field_150360_v, 1, 1), Character.valueOf('Z'), Items.field_179563_cD, Character.valueOf('A'), Items.field_151115_aP);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)magmacube, 4, 0), "XXX", "X X", "XXX", Character.valueOf('X'), Items.field_151064_bs);
        for (i = 0; i < 3; ++i) {
            CraftableAnimals.addRecipe(2, new ItemStack((Item)magmacube, 1, i + 1), "XX", "XX", Character.valueOf('X'), new ItemStack((Item)magmacube, 1, i));
        }
        CraftableAnimals.addRecipe(0, new ItemStack((Item)shulker, 2), " Y ", "XXX", Character.valueOf('X'), Blocks.field_185767_cT, Character.valueOf('Y'), Items.field_190930_cZ);
        CraftableAnimals.addRecipe(1, new ItemStack((Item)silverfish, 2), Items.field_151115_aP, Items.field_151042_j);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)skeleton, 2), "XZX", "ZYZ", "XZX", Character.valueOf('X'), Items.field_151103_aS, Character.valueOf('Y'), Items.field_151031_f, Character.valueOf('Z'), Items.field_151032_g);
        CraftableAnimals.addRecipe(2, new ItemStack((Item)skeleton_wither, 2), "X X", "YZY", "X X", Character.valueOf('X'), Items.field_151103_aS, Character.valueOf('Y'), Items.field_151044_h, Character.valueOf('Z'), Items.field_151052_q);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)skeleton_stray, 1), skeleton, Blocks.field_150433_aE);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)spider, 4), "XYX", "Y Y", "XYX", Character.valueOf('X'), Items.field_151007_F, Character.valueOf('Y'), Items.field_151070_bp);
        CraftableAnimals.addRecipe(1, new ItemStack((Item)jockey, 1, 0), skeleton, spider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 1), new ItemStack((Item)skeleton, 1, 2), spider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 2), zombie, spider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 3), new ItemStack((Item)zombie, 1, 6), spider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 4), zombiepig, spider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 5), creeper, spider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 6), skeleton, cavespider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 7), new ItemStack((Item)skeleton, 1, 2), cavespider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 8), zombie, cavespider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 9), new ItemStack((Item)zombie, 1, 6), cavespider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 10), zombiepig, cavespider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 11), creeper, cavespider);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 12), skeleton, chicken);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 13), new ItemStack((Item)skeleton, 1, 2), chicken);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 14), zombie, chicken);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 15), new ItemStack((Item)zombie, 1, 6), chicken);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 16), zombiepig, chicken);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)jockey, 1, 17), creeper, chicken);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)slime, 4, 0), "XXX", "X X", "XXX", Character.valueOf('X'), Items.field_151123_aH);
        for (i = 0; i < 4; ++i) {
            CraftableAnimals.addRecipe(2, new ItemStack((Item)slime, 1, i + 1), "XX", "XX", Character.valueOf('X'), new ItemStack((Item)slime, 1, i));
        }
        CraftableAnimals.addRecipe(1, new ItemStack((Item)vex, 4), evoker);
        CraftableAnimals.addRecipe(0, new ItemStack((Item)vindicator, 3), " X", "YX", " X", Character.valueOf('X'), Items.field_151166_bC, Character.valueOf('Y'), Items.field_151036_c);
        CraftableAnimals.addRecipe(1, new ItemStack((Item)witch, 2), Items.field_151137_ax, Items.field_151114_aO, Items.field_151102_aT, Items.field_151016_H, Items.field_151069_bo, Items.field_151070_bp, Items.field_151055_y, new ItemStack((Item)Items.field_151068_bn, 1, 0));
        CraftableAnimals.addRecipe(0, new ItemStack((Item)zombie, 4), "XXX", "XYX", "XXX", Character.valueOf('X'), Items.field_151078_bh, Character.valueOf('Y'), Items.field_151008_G);
        CraftableAnimals.addRecipe(3, new ItemStack((Item)zombie_villager, 2, 0), zombie, new ItemStack((Item)villager, 1, 0));
        CraftableAnimals.addRecipe(3, new ItemStack((Item)zombie_villager, 2, 1), zombie, new ItemStack((Item)villager, 1, 1));
        CraftableAnimals.addRecipe(3, new ItemStack((Item)zombie_villager, 2, 2), zombie, new ItemStack((Item)villager, 1, 2));
        CraftableAnimals.addRecipe(3, new ItemStack((Item)zombie_villager, 2, 3), zombie, new ItemStack((Item)villager, 1, 3));
        CraftableAnimals.addRecipe(3, new ItemStack((Item)zombie_villager, 2, 4), zombie, new ItemStack((Item)villager, 1, 4));
        CraftableAnimals.addRecipe(3, new ItemStack((Item)zombie_husk, 1), zombie, Blocks.field_150354_m);
        if (!CAConfig.serverMode) {
            CraftableAnimals.addRecipe(0, new ItemStack((Item)enderdragon, 1, 0), "YAY", "AXA", "YZY", Character.valueOf('X'), Blocks.field_150380_bt, Character.valueOf('Y'), Blocks.field_150377_bs, Character.valueOf('Z'), Blocks.field_150484_ah, Character.valueOf('A'), Items.field_151061_bv);
            CraftableAnimals.addRecipe(0, new ItemStack((Item)giant, 1), "X", "X", "X", Character.valueOf('X'), zombie);
            CraftableAnimals.addRecipe(0, new ItemStack((Item)wither, 1), "XXX", "YYY", " Y ", Character.valueOf('X'), new ItemStack(Items.field_151144_bL, 1, 1), Character.valueOf('Y'), Blocks.field_150425_aM);
        }
        CraftableAnimals.addRecipe(4, new ItemStack((Item)crystal, 1), "XYX", "ZAZ", "AAA", Character.valueOf('X'), Blocks.field_150359_w, Character.valueOf('Y'), Items.field_151033_d, Character.valueOf('Z'), Items.field_151061_bv, Character.valueOf('A'), Blocks.field_150343_Z);
        CraftableAnimals.addRecipe(4, new ItemStack((Item)minimizer, 1), "X  ", "XY ", "XYZ", Character.valueOf('X'), pig, Character.valueOf('Y'), sheep, Character.valueOf('Z'), cow);
        CraftableAnimals.addRecipe(4, new ItemStack((Item)minecart, 1), new Object[]{"X", "Y", Character.valueOf('X'), spawner, Character.valueOf('Y'), Items.field_151143_au});
        CraftableAnimals.addRecipe(4, new ItemStack((Item)armorer, 1), "X X", "XXX", "XXX", Character.valueOf('X'), Blocks.field_150347_e);
        CraftableAnimals.addRecipe(4, new ItemStack((Block)spawner, 1), "XXX", "X X", "XXX", Character.valueOf('X'), Blocks.field_150411_aY);
        CraftableAnimals.addRecipe(5, new ItemStack((Item)soul, 1), Items.field_151045_i, Items.field_151061_bv);
        List r = CraftingManager.func_77594_a().func_77592_b();
        RecipeSorter.register((String)"craftableAnimal:porkchop", CARecipes.totallyNotAHiddenRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        r.add(new CARecipes.totallyNotAHiddenRecipe());
        RecipeSorter.register((String)"craftableAnimal:bow", CARecipes.bow.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        r.add(new CARecipes.bow());
        RecipeSorter.register((String)"craftableAnimal:baby", CARecipes.baby.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        r.add(new CARecipes.baby());
        RecipeSorter.register((String)"craftableAnimal:baby2", CARecipes.baby2.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        r.add(new CARecipes.baby2());
        RecipeSorter.register((String)"craftableAnimal:display", CARecipes.display.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        r.add(new CARecipes.display());
        RecipeSorter.register((String)"craftableAnimal:enderman", CARecipes.enderman.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        r.add(new CARecipes.enderman());
        RecipeSorter.register((String)"craftableAnimal:soulCloning", CARecipes.soulCloning.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        r.add(new CARecipes.soulCloning());
    }

    public static void addRecipe(int t, ItemStack stack, Object ... ingredients) {
        if (t % 2 == 0) {
            GameRegistry.addShapedRecipe((ItemStack)stack, (Object[])ingredients);
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)stack, (Object[])ingredients);
        }
        IRecipe r = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(CraftingManager.func_77594_a().func_77592_b().size() - 1);
        if (t / 2 == 0) {
            recipes.put(r, new ArrayList());
            recipes.get(r).add(r);
        } else if (t / 2 == 1) {
            recipes.get(recipes.keySet().toArray()[recipes.size() - 1]).add(r);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayer player;
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.getEntityLiving();
        World world = entity.field_70170_p;
        if (entity.func_70681_au().nextInt(101) <= CAConfig.chanceOfDrop && !world.field_72995_K) {
            try {
                world.func_72838_d((Entity)new EntityItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Item)CraftableAnimalsRegistry.getItemFromName(SpawnEntity.getNameFromEntity(entity)), 1, SpawnEntity.getTypeFromEntity(entity))));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (entity instanceof EntityPig && event.getSource().field_76373_n.contentEquals("player") && (player = (EntityPlayer)event.getSource().func_76364_f()).func_184614_ca() != null && player.func_184614_ca().func_77973_b() == Items.field_151122_aG) {
            ItemStack stack = new ItemStack((Item)guide, 1);
            if (player.func_184614_ca().func_190916_E() == 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
            } else {
                player.func_184614_ca().func_190917_f(-1);
                if (!player.field_71071_by.func_70441_a(stack)) {
                    player.func_71019_a(stack, false);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!CAConfig.shiftClickArmor) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        ItemStack stack = player.func_184614_ca();
        if (stack != null && entity instanceof EntityLiving && player.func_70093_af()) {
            ItemCraftableAnimal item = CraftableAnimalsRegistry.getItemFromName(SpawnEntity.getNameFromEntity((EntityLiving)entity));
            if (item == null) {
                return;
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(1);
            if (stack.func_77973_b() instanceof ItemArmor) {
                int armorType = ((ItemArmor)stack.func_77973_b()).field_77881_a.ordinal();
                if ((CraftableAnimalsRegistry.getPropertiy(item, 'a') & (int)Math.pow(2.0, 6 - armorType) - 1) != 0) {
                    ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.values()[armorType], newStack);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190917_f(-1);
                    }
                }
            } else if ((CraftableAnimalsRegistry.getPropertiy(item, 'a') & 0x10) != 0) {
                if (stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemBow || stack.func_77973_b() instanceof ItemSword) {
                    ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.MAINHAND, newStack);
                } else {
                    ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.OFFHAND, newStack);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190917_f(-1);
                }
            }
        }
    }

    public static void checkVersion() {
        if (CAConfig.updateCheck == 0) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    URL url = new URL("https://dl.dropboxusercontent.com/u/73045391/static/caversion.txt");
                    InputStream in = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)in));
                    in.close();
                    for (String v : data.split(";")) {
                        if (!v.startsWith(Loader.instance().getMCVersionString().substring(10) + ":")) continue;
                        latestVersion = v.split(":")[1];
                        try {
                            String[] latest = latestVersion.split("\\.");
                            String[] current = CraftableAnimals.version.split("\\.");
                            for (int i = 0; i < current.length; ++i) {
                                if (Integer.valueOf(latest[i]) > Integer.valueOf(current[i])) {
                                    isLatestVersion = false;
                                    return;
                                }
                                if (Integer.valueOf(latest[i]) >= Integer.valueOf(current[i])) continue;
                                return;
                            }
                            if (latest.length <= current.length) continue;
                            isLatestVersion = false;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("[CraftableAnimals] Update check failed.");
                    latestVersion = "<check failed>";
                    return;
                }
            }
        }.start();
    }

    @SubscribeEvent
    public void onWorldLoaded(WorldEvent.Load event) {
        if (!CraftableAnimals.instance.worldLoaded && CAConfig.updateCheck == 2 && !isLatestVersion && FMLCommonHandler.instance().getSide().isClient()) {
            new Thread(){

                @Override
                public void run() {
                    while (Minecraft.func_71410_x().field_71439_g == null) {
                        System.out.println(Minecraft.func_71410_x().field_71439_g);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("A newer version of CraftableAnimals is available: " + latestVersion));
                }
            }.start();
            CraftableAnimals.instance.worldLoaded = true;
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        if (CAConfig.removeEggs) {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            int removed = 0;
            for (ResourceLocation i : EntityList.field_75627_a.keySet()) {
                if (!CraftableAnimalsRegistry.getNameToItemMap().containsKey(i)) continue;
                toRemove.add(i);
            }
            for (ResourceLocation i : toRemove) {
                if (EntityList.field_75627_a.remove(i) == null) continue;
                ++removed;
            }
            System.out.println("Craftable Animals removed " + removed + " spawn eggs.");
        }
    }

    public static boolean isActivated_MobSpawnerBaseLogic(MobSpawnerBaseLogic l) {
        int range;
        try {
            if (fieldActivatingRangeFromPlayer == null) {
                int i = 5;
                for (Field f : MobSpawnerBaseLogic.class.getDeclaredFields()) {
                    if (f.getType() != Integer.TYPE) continue;
                    if (i > 0) {
                        --i;
                        continue;
                    }
                    f.setAccessible(true);
                    fieldActivatingRangeFromPlayer = f;
                    break;
                }
            }
            range = fieldActivatingRangeFromPlayer.getInt(l);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            range = 16;
        }
        BlockPos pos = l.func_177221_b();
        boolean s = l.func_98271_a().func_175636_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)range);
        return s && l.func_98271_a().func_175687_A(pos) == 0;
    }

    public static ItemStack getPickedEntityResult_entity(Entity entity, RayTraceResult target) {
        if (entity instanceof EntityLiving) {
            ItemCraftableAnimal item = null;
            if (target.field_72308_g instanceof EntityLiving) {
                item = CraftableAnimalsRegistry.getItemFromName(SpawnEntity.getNameFromEntity((EntityLiving)target.field_72308_g));
            }
            if (item != null) {
                return new ItemStack((Item)item, 1, SpawnEntity.getTypeFromEntity((EntityLiving)target.field_72308_g));
            }
        }
        if (entity instanceof EntityPainting) {
            return new ItemStack(Items.field_151159_an);
        }
        if (entity instanceof EntityLeashKnot) {
            return new ItemStack(Items.field_151058_ca);
        }
        if (entity instanceof EntityItemFrame) {
            ItemStack held = ((EntityItemFrame)entity).func_82335_i();
            if (held == null) {
                return new ItemStack(Items.field_151160_bD);
            }
            return held.func_77946_l();
        }
        if (entity instanceof EntityMinecart) {
            return ((EntityMinecart)entity).getCartItem();
        }
        if (entity instanceof EntityBoat) {
            return new ItemStack(((EntityBoat)entity).func_184455_j());
        }
        if (entity instanceof EntityArmorStand) {
            return new ItemStack((Item)Items.field_179565_cj);
        }
        if (entity instanceof EntityEnderCrystal) {
            return new ItemStack(Items.field_185158_cP);
        }
        ResourceLocation name = EntityList.func_191306_a(entity.getClass());
        if (EntityList.field_75627_a.containsKey(name)) {
            ItemStack stack = new ItemStack(Items.field_151063_bx);
            ItemMonsterPlacer.func_185078_a((ItemStack)stack, (ResourceLocation)name);
            return stack;
        }
        return null;
    }

    static {
        recipes = new LinkedHashMap<IRecipe, List<IRecipe>>();
    }
}

