/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla.item.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import naruto1310.craftableAnimals.core.CraftableAnimalsRegistry;
import naruto1310.craftableAnimals.core.ItemCraftableAnimal;
import naruto1310.craftableAnimals.vanilla.CAConfig;
import naruto1310.craftableAnimals.vanilla.CraftableAnimals;
import naruto1310.craftableAnimals.vanilla.item.gui.ContainerGuideBook;
import naruto1310.craftableAnimals.vanilla.item.gui.GuiButtonInvisible;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameData;
import org.lwjgl.opengl.GL11;

public class GuiGuideBook
extends GuiContainer {
    private static final ResourceLocation tex = new ResourceLocation("craftableAnimals:textures/gui/guideBook.png");
    private static final ResourceLocation texExtra = new ResourceLocation("craftableAnimals:textures/gui/guideBook_extra.png");
    private static final ResourceLocation texCrafting = new ResourceLocation("textures/gui/container/crafting_table.png");
    private static final ResourceLocation texAnvil = new ResourceLocation("textures/gui/container/anvil.png");
    private ContainerGuideBook container;
    private int x;
    private int y;
    private int tabPrimary = 0;
    private int tabSecondary = 0;
    private int page = 0;
    private int[] data = null;
    private final String[][] secondaryTabLabels = new String[][]{{"Introduction", "Crafting animals", "Using animals", "Stacking animals", "Animals as hats", "Armoring animals", "Baby animals"}, {"Animal bow", "Minimizer", "Animal soul", "Animal armorer", "Empty Spawner", "Animal Display Case"}, {"Ender crystal", "Guide book", "Animal drops", "Remove spawn eggs", "About"}};

    public GuiGuideBook() {
        super((Container)new ContainerGuideBook());
        this.container = (ContainerGuideBook)this.field_147002_h;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.x = (this.field_146294_l - 296) / 2;
        this.y = (this.field_146295_m - 220) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButtonInvisible(0, this.x + 94, this.y, 70, 16));
        this.field_146292_n.add(new GuiButtonInvisible(1, this.x + 168, this.y, 70, 16));
        this.field_146292_n.add(new GuiButtonInvisible(2, this.x + 242, this.y, 70, 16));
        GuiButton b3 = new GuiButton(3, this.x + 100, this.y + 190, 20, 20, "<");
        this.field_146292_n.add(b3);
        GuiButton b4 = new GuiButton(4, this.x + 130, this.y + 190, 20, 20, ">");
        this.field_146292_n.add(b4);
        this.field_146292_n.add(new GuiButton(5, this.x + 250, this.y + 190, 50, 20, this.data == null ? "Close" : "Back"));
        for (int i = 0; i < this.secondaryTabLabels[this.tabPrimary].length; ++i) {
            this.field_146292_n.add(new GuiButtonInvisible(10 + i, this.x - 17, this.y + 40 + 20 * i, 108, 19));
        }
        if (this.getPages() == 1) {
            b4.field_146124_l = false;
            b3.field_146124_l = false;
        }
        if (this.tabPrimary == 0 && this.tabSecondary == 1 && this.data == null) {
            if (CraftableAnimals.recipes.get(CraftableAnimals.recipes.keySet().toArray()[this.page * 2]).size() > 1) {
                this.field_146292_n.add(new GuiButton(6, this.x + 270, this.y + 67, 32, 20, "More"));
            }
            if (CraftableAnimals.recipes.size() > this.page * 2 + 1 && CraftableAnimals.recipes.get(CraftableAnimals.recipes.keySet().toArray()[this.page * 2 + 1]).size() > 1) {
                this.field_146292_n.add(new GuiButton(7, this.x + 270, this.y + 137, 32, 20, "More"));
            }
        }
        if (this.tabPrimary == 2 && this.tabSecondary == 4 && CAConfig.updateCheck != 0) {
            this.field_146292_n.add(new GuiButton(6, this.x + 240, this.y + 64, 64, 20, "Check now"));
            this.field_146292_n.add(new GuiButtonInvisible(7, this.x + 188, this.y + 159, 114, 10));
        }
        this.container.update(this.tabPrimary, this.tabSecondary, this.page, this.data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        int id = button.field_146127_k;
        if (id <= 2) {
            this.tabPrimary = button.field_146127_k;
            this.tabSecondary = 0;
            this.page = 0;
            this.data = null;
        }
        if (id == 3) {
            this.page = this.page > 0 ? --this.page : this.getPages() - 1;
        }
        if (id == 4) {
            this.page = this.page < this.getPages() - 1 ? ++this.page : 0;
        }
        if (id == 5) {
            if (this.data == null) {
                this.field_146297_k.func_147108_a(null);
                return;
            }
            this.page = 0;
            if (this.tabPrimary == 0 && this.tabSecondary == 1) {
                this.page = this.data[0] / 2;
            }
            this.data = null;
        }
        if (id > 9) {
            this.tabSecondary = id - 10;
            this.page = 0;
            this.data = null;
        }
        block1 : switch (this.tabPrimary) {
            case 0: {
                switch (this.tabSecondary) {
                    case 1: {
                        if (id == 6) {
                            this.data = new int[]{this.page * 2};
                            this.page = 0;
                        }
                        if (id == 7) {
                            this.data = new int[]{this.page * 2 + 1};
                            this.page = 0;
                            break;
                        }
                        break block1;
                    }
                }
                break;
            }
            case 2: {
                switch (this.tabSecondary) {
                    case 4: {
                        if (id == 6) {
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    CraftableAnimals.latestVersion = "Checking...";
                                    CraftableAnimals.checkVersion();
                                }
                            };
                            t.start();
                        }
                        if (id != 7 || !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) break;
                        try {
                            Desktop.getDesktop().browse(new URL("http://bit.ly/craftableAnimals").toURI());
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                break;
            }
        }
        this.func_73866_w_();
    }

    private int getPages() {
        if (this.tabPrimary == 0 && this.tabSecondary == 1) {
            if (this.data == null) {
                return (CraftableAnimals.recipes.size() + 1) / 2;
            }
            return (CraftableAnimals.recipes.get(CraftableAnimals.recipes.keySet().toArray()[this.data[0]]).size() + 1) / 2;
        }
        if (this.tabPrimary == 0 && (this.tabSecondary == 4 || this.tabSecondary == 5) || this.tabPrimary == 1 && (this.tabSecondary == 0 || this.tabSecondary == 5)) {
            return 2;
        }
        if (this.tabPrimary == 1 && this.tabSecondary == 4) {
            return 3;
        }
        if (this.tabPrimary == 1 && this.tabSecondary == 3) {
            return 4;
        }
        return 1;
    }

    protected void func_146976_a(float f, int i0, int i1) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        this.func_73729_b(this.x + 90, this.y, 0, 0, 226, 220);
        this.func_73729_b(this.x + 94 + this.tabPrimary * 74, this.y, 0, 220, 70, 19);
        for (i = 0; i < this.secondaryTabLabels[this.tabPrimary].length; ++i) {
            this.func_73729_b(this.x - 17, this.y + 40 + 20 * i, 70, i == this.tabSecondary ? 238 : 220, 110, 18);
        }
        this.field_146289_q.func_78276_b("Craftable Animals Guide Book", this.field_146294_l / 2 + 65 - this.field_146289_q.func_78256_a("Craftable Animals Guide Book") / 2, this.y + 22, 0x404040);
        this.field_146289_q.func_78276_b("The basics", this.x + 102, this.y + 5, 0x404040);
        this.field_146289_q.func_78276_b("Items", this.x + 176, this.y + 5, 0x404040);
        this.field_146289_q.func_78276_b("Extras", this.x + 250, this.y + 5, 0x404040);
        for (i = 0; i < this.secondaryTabLabels[this.tabPrimary].length; ++i) {
            for (int j = 0; j < this.secondaryTabLabels[this.tabPrimary].length; ++j) {
                this.field_146289_q.func_78276_b(this.secondaryTabLabels[this.tabPrimary][j], this.x - 12, this.y + 45 + j * 20, 0x404040);
            }
        }
        if (this.getPages() != 1) {
            this.field_146289_q.func_78276_b(this.page + 1 + "/" + this.getPages(), this.x + 160, this.y + 196, 0x404040);
        }
        this.drawTextures();
        this.drawContent();
    }

    private void drawContent() {
        String content = "Coming soon.";
        LinkedList<String> content2 = new LinkedList<String>();
        block1 : switch (this.tabPrimary) {
            case 0: {
                switch (this.tabSecondary) {
                    case 0: {
                        content = "Welcome to the Craftable Animals mod!\nThis mod adds a variety of tools and features dealing with mobs. It was first released in 2011 for Minecraft Beta 1.8.1 (before the announcement and introduction of spawn eggs).\nToday the mod features not only over 100 items, but also many tools that improve handling mobs as well as improvements to the behavior of animals.\nThe mod is fully SMP compatible (hopefully).";
                        break;
                    }
                    case 1: {
                        content = null;
                        break;
                    }
                    case 2: {
                        content = "Once an animal is crafted, it will be locked into a single slot in the inventory. It this state, it will not wander off, require food or show any other sign of being alive. Animals can be awakened from this state by holding them and right clicking on a block. Dispensers can be used as another way of releasing them. After an animal has been placed it is indistinguishable from a naturally spawned one.\nA team of mostly independent scientists has confirmed, that animals do not suffer while being locked into the inventory.";
                        break;
                    }
                    case 3: {
                        content = "Animal can be stacked on top of each other. Right clicking a living animal while holding a crafted one will make it ride it. This works multiple times, so it is possible to create huge towers of animals.\nThis way, it is also possible to place animals in boats or minecarts.";
                        break;
                    }
                    case 4: {
                        if (this.page == 0) {
                            content = "Show everyone how funky you are, by wearing an animal on your head!\nTo do so, just place it in your helmet slot.\nAnimals as helmets do not provide any protection like a helmet would. However, they provide lots of fun and a companion that goes wherever you go.";
                            break;
                        }
                        content = "";
                        break;
                    }
                    case 5: {
                        if (this.page == 0) {
                            content = "Armor can be applied to animals, by holding shift and right clicking on a living animal while holding a piece of armor.\nNot ever animal can wear any kind of armor. Zombies, skeletons, zombie pigmen and wither skeletons support all kinds of armor, as well as a tool.\nOther than that, many animals have are able to wear some kind of armor. Most animals support helmets and boots. A few also support chestplates.\nTo learn more about animal and armor, see the animal armorer on the items tab.";
                            break;
                        }
                        content = "\n\n\n\n\n\n\n\n\nIf this mod is uninstalled after applying armor, it will still absorb damage but it will be invisible.";
                        break;
                    }
                    case 6: {
                        content = "Animals that have baby versions can be turned into babys before placing them. To do this place the animal in a crafting grid alongside a block of dirt. A red star will indicate that an animal is a baby. Two babys can be combined back to the regular animal.";
                    }
                }
                break;
            }
            case 1: {
                block15 : switch (this.tabSecondary) {
                    case 0: {
                        if (this.page == 0) {
                            content = "The animal bow is a tool that can be used to place animals at a distance.\nIt is crafted using a bow and any crafted animal. The animal used does not affect the resulting bow.";
                            break;
                        }
                        content = "To shoot the bow both an arrow and an animal are required.\nShooting an arrow will consume the first animal from your inventory. The animal will come to life wherever the arrow lands.\nWhen a living animal is hit by such an arrow it will be transformed into the animal that was shot.";
                        break;
                    }
                    case 1: {
                        content = "The minimizer has the ability to shrink animals into baby or let them grow up, instantly.\nLeft clicking an animal will turn it into a baby. Right clicking them will make them an adult.\nThis will only work on animals that have baby versions.";
                        break;
                    }
                    case 2: {
                        content = "The animal soul can capture animal in their current form an release them again.\nIt captures animals exactly how they are, including their health, equipment, position of their limbs, their name, whether something is riding on them ...";
                        break;
                    }
                    case 3: {
                        if (this.page == 0) {
                            content = "The animal armorer can be used to apply armor to almost any animal.\nIt can apply a helmet, chestplate, a pair of pants, boots, as well as a tool and up to five potions.\nWhich of these is available depends on the animal.";
                            break;
                        }
                        if (this.page == 1) {
                            content = "Many animals, that can't wear armor in the vanilla game can be armored using the armorer.\nMost animals support helmets and boots. A few can also wear pants and hold a tool. Unsupported slots will be crossed out.\nEvery animal can take up to five potions. Both regular and splash potions can be equipped.\nThe second column displays the equipment, that the animal is currently wearing.";
                            break;
                        }
                        Object[] items = CraftableAnimalsRegistry.getNameToItemMap().values().toArray();
                        content = "Currently allowed combinations:\n\n\n\n";
                        int perPage = 10;
                        int currPage = this.page == 2 ? 0 : -1 - perPage;
                        content2.add("087\n\n\n");
                        for (int j = 1; j < 5; ++j) {
                            content2.add(87 + j * 20 + "\n\n\n");
                        }
                        for (int i = 0; i < items.length; ++i) {
                            ItemCraftableAnimal item = (ItemCraftableAnimal)items[i];
                            if (!CraftableAnimalsRegistry.getProperties(item).containsKey(Character.valueOf('a')) || ++currPage < 0) continue;
                            if (currPage > perPage) break block15;
                            content = content + I18n.func_74838_a((String)("entity." + ((EntityEntry)GameData.getEntityRegistry().getValue(item.getAnimal())).getName() + ".name")) + ":\n";
                            for (int j = 0; j < 5; ++j) {
                                content2.set(j, (String)content2.get(j) + "\n");
                            }
                            int a = CraftableAnimalsRegistry.getPropertiy(item, 'a');
                            for (int j = 0; j < 5; ++j) {
                                if ((a & 1) != 0) {
                                    content2.set(j, (String)content2.get(j) + "x");
                                }
                                a /= 2;
                            }
                        }
                        break block1;
                    }
                    case 4: {
                        if (this.page == 0) {
                            content = "The empty spawner is a craftable spawner.\nAfter being placed it is inactive at first. To activate it, right click it with an animal. From that point on it behaves like a regular spawner.";
                            break;
                        }
                        if (this.page == 1) {
                            content = "After that it can still be changed into a different spawner using a different animal.\n\nA spawner in a minecart can be created and used in the same way.";
                            break;
                        }
                        content = "Once a spawner has been activated, it works independent of the mod, so it is safe to give the map away to people that don't have the mod.\n\nPowering a spawner with redstone will make it pause. This feature depends on the mod and will not work when giving the map away or uninstalling the mod.";
                        break;
                    }
                    case 5: {
                        if (this.page == 0) {
                            content = "The animal display case is a block capable of displaying an animal as a hologram.\nUsing the settings screen, the size and position of the hologram can be adjusted. It can also be set to rotate left or right.";
                            break;
                        }
                        content = "If the rotation is turned off, powering the block with redstone, will cause the display case to turn off. If the rotation is turned on, powering it will stop the rotation.\nHolding the sneak key while clicking some buttons in the settings screen will increase their effect.";
                    }
                }
                break;
            }
            case 2: {
                switch (this.tabSecondary) {
                    case 0: {
                        content = "This item can be used to place an ender crystal.\nAdditionally to placing an ender crystal, this item has the ability to remove it without an explosion. To do so, simply left click an ender crystal while holding the item.";
                        break block1;
                    }
                    case 1: {
                        content = "The guide book explains all the features of this mod.\nIt can be obtained by slaying a pig while holding a regular book.";
                        break block1;
                    }
                    case 2: {
                        content = "Every time an animal dies, there is a small chance of that animal dropping itself as an item.\nThis happens independently of whether the animal was killed by a player or not.\nBy default this chance is 1%. It can be adjusted or turned off completely using the configuration file.";
                        break block1;
                    }
                    case 3: {
                        content = "Now that you have craftable animals, you don't need spawn eggs anymore.\nAs people got confused about this feature, it is turned off by default. It can be enabled using the configuration file.\nIf enabled, only vanilla spawn eggs will be removed. Spawn eggs, added by mods will still be available.";
                        break block1;
                    }
                    case 4: {
                        int types = 0;
                        long total = 0L;
                        for (ItemCraftableAnimal item : CraftableAnimalsRegistry.getNameToItemMap().values()) {
                            types += item.getTypes();
                            if (CraftableAnimalsRegistry.getProperties(item).containsKey(Character.valueOf('b'))) {
                                ++total;
                            }
                            int currArmor = item.getTypes();
                            if (CraftableAnimalsRegistry.getProperties(item).containsKey(Character.valueOf('a'))) {
                                int a = CraftableAnimalsRegistry.getPropertiy(item, 'a');
                                for (int i = 0; i < 4; ++i) {
                                    int mul = 1;
                                    if ((a & 1) != 0) {
                                        for (int j = 0; j < Item.field_150901_e.func_148742_b().size(); ++j) {
                                            Item it = (Item)Item.field_150901_e.func_148754_a(j);
                                            if (!(it instanceof ItemArmor) || ((ItemArmor)it).field_77881_a.func_188452_c() != i + 1) continue;
                                            ++mul;
                                        }
                                    }
                                    currArmor *= mul;
                                    a /= 2;
                                }
                                if ((a & 1) != 0) {
                                    currArmor *= Item.field_150901_e.func_148742_b().size();
                                }
                            }
                            total += (long)currArmor;
                        }
                        content = "Craftable Animals mod\n\nVersion:\nLatest version:\nExtensions:\nAnimals added:\nDifferent types:\nTotal number of possible combinations:\n\n\n\nmore information:\n\u00a79\u00a7nbit.ly/craftableAnimalsMod\u00a7r\nCopyright Naruto1310 2011-2016";
                        String t = "";
                        while (total != 0L) {
                            t = total % 1000L + "," + t;
                            while (t.length() % 4 != 0) {
                                t = "0" + t;
                            }
                            total /= 1000L;
                        }
                        while (t.startsWith("0")) {
                            t = t.substring(1);
                        }
                        t = t.substring(0, t.length() - 1);
                        content2.add("085\n\n2.7.0\n" + (CAConfig.updateCheck == 0 ? "<Check disabled>" : CraftableAnimals.latestVersion) + "\n" + CraftableAnimalsRegistry.getExtensions().size() + "\n" + CraftableAnimalsRegistry.getNameToItemMap().size() + "\n" + types + "\n\n" + t);
                    }
                }
            }
        }
        if (content != null) {
            ArrayList<String> text = new ArrayList<String>();
            try {
                for (String line : content.split("\n")) {
                    text.add("");
                    for (String word : line.split(" ")) {
                        String newLine = (String)text.get(text.size() - 1) + (((String)text.get(text.size() - 1)).contentEquals("") ? "" : " ") + word;
                        if (this.field_146289_q.func_78256_a(newLine) < 206) {
                            text.set(text.size() - 1, newLine);
                            continue;
                        }
                        text.add(word);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            for (int t = 0; t < text.size(); ++t) {
                this.field_146289_q.func_78276_b((String)text.get(t), this.x + 100, this.y + 40 + t * 10, 0x404041);
            }
        }
        for (String c : content2) {
            int shift = Integer.valueOf(c.substring(0, 3));
            String[] text = c.substring(3).split("\n");
            for (int t = 0; t < text.length; ++t) {
                this.field_146289_q.func_78276_b(text[t], this.x + 100 + shift, this.y + 40 + t * 10, 0x404040);
            }
        }
    }

    private void drawTextures() {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.tabPrimary) {
            case 0: {
                switch (this.tabSecondary) {
                    case 1: {
                        this.field_146297_k.func_110434_K().func_110577_a(texCrafting);
                        this.func_73729_b(this.x + 145, this.y + 50, 29, 16, 116, 54);
                        if (this.data == null ? CraftableAnimals.recipes.size() <= this.page * 2 + 1 : CraftableAnimals.recipes.get(CraftableAnimals.recipes.keySet().toArray()[this.data[0]]).size() <= this.page * 2 + 1) {
                            return;
                        }
                        this.func_73729_b(this.x + 145, this.y + 120, 29, 16, 116, 54);
                        break;
                    }
                    case 4: {
                        if (this.page != 1) break;
                        this.field_146297_k.func_110434_K().func_110577_a(texExtra);
                        float f04 = 0.6f;
                        GL11.glScalef((float)f04, (float)f04, (float)1.0f);
                        this.func_73729_b((int)((float)(this.x + 110) / f04), (int)((float)(this.y + 95) / f04), 145, 0, 65, 110);
                        this.func_73729_b((int)((float)(this.x + 248) / f04), (int)((float)(this.y + 95) / f04), 145, 0, 65, 110);
                        this.func_73729_b((int)(((float)(this.x + 248) + 2.0f * f04) / f04), (int)(((float)(this.y + 95) - 74.0f * f04) / f04), 210, 0, 45, 87);
                        GL11.glScalef((float)(1.0f / f04), (float)(1.0f / f04), (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(texAnvil);
                        this.func_73729_b(this.x + 170, this.y + 120, 53, 49, 13, 13);
                        this.func_73729_b(this.x + 218, this.y + 120, 102, 48, 22, 15);
                        this.field_146297_k.func_110434_K().func_110577_a(texCrafting);
                        this.func_73729_b(this.x + 193, this.y + 118, 29, 16, 18, 18);
                        break;
                    }
                    case 5: {
                        if (this.page != 1) break;
                        this.field_146297_k.func_110434_K().func_110577_a(texExtra);
                        float f05 = 0.333f;
                        GL11.glScalef((float)f05, (float)f05, (float)1.0f);
                        this.func_73729_b((int)((float)(this.x + 110) / f05), (int)((float)(this.y + 65) / f05), 0, 0, 144, 144);
                        this.func_73729_b((int)((float)(this.x + 248) / f05), (int)((float)(this.y + 65) / f05), 0, 0, 144, 144);
                        this.func_73729_b((int)((float)(this.x + 248 - 4) / f05), (int)((float)(this.y + 62) / f05), 0, 144, 111, 59);
                        GL11.glScalef((float)(1.0f / f05), (float)(1.0f / f05), (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(texAnvil);
                        this.func_73729_b(this.x + 170, this.y + 80, 53, 49, 13, 13);
                        this.func_73729_b(this.x + 218, this.y + 80, 102, 48, 22, 15);
                        this.field_146297_k.func_110434_K().func_110577_a(texCrafting);
                        this.func_73729_b(this.x + 193, this.y + 78, 29, 16, 18, 18);
                        break;
                    }
                    case 6: {
                        this.field_146297_k.func_110434_K().func_110577_a(texCrafting);
                        this.func_73729_b(this.x + 145, this.y + 120, 29, 16, 116, 54);
                    }
                }
                break;
            }
            case 1: {
                if (this.page == 0 || this.tabSecondary == 4 && this.page < 2) {
                    this.field_146297_k.func_110434_K().func_110577_a(texCrafting);
                    this.func_73729_b(this.x + 145, this.y + 120, 29, 16, 116, 54);
                }
                if (this.tabSecondary != 3 || this.page < 2) break;
                this.field_146297_k.func_110434_K().func_110577_a(texCrafting);
                this.func_73729_b(this.x + 180, this.y + 56, 29, 16, 18, 18);
                this.func_73729_b(this.x + 200, this.y + 56, 29, 16, 18, 18);
                this.func_73729_b(this.x + 220, this.y + 56, 29, 16, 18, 18);
                this.func_73729_b(this.x + 240, this.y + 56, 29, 16, 18, 18);
                this.func_73729_b(this.x + 260, this.y + 56, 29, 16, 18, 18);
                break;
            }
            case 2: {
                if (this.tabSecondary != 0) break;
                this.field_146297_k.func_110434_K().func_110577_a(texCrafting);
                this.func_73729_b(this.x + 145, this.y + 120, 29, 16, 116, 54);
            }
        }
    }
}

