/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import naruto1310.craftableAnimals.core.AbstractCraftableAnimalsExtension;
import naruto1310.craftableAnimals.core.ICraftableAnimal;
import naruto1310.craftableAnimals.core.ItemCraftableAnimal;
import naruto1310.craftableAnimals.core.ItemCraftableAnimalBase;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLLog;

public class CraftableAnimalsRegistry {
    private static final List<AbstractCraftableAnimalsExtension> extensions = new ArrayList<AbstractCraftableAnimalsExtension>();
    private static final Map<ResourceLocation, ItemCraftableAnimal> nameToItemMap = new LinkedHashMap<ResourceLocation, ItemCraftableAnimal>();
    private static final Map<ItemCraftableAnimal, Map<Character, Integer>> itemProperties = new HashMap<ItemCraftableAnimal, Map<Character, Integer>>();
    private static boolean hasInit = false;

    public static void init() {
        if (!hasInit) {
            EnumHelper.addArmorMaterial((String)"craftableAnimal", (String)"craftableAnimal", (int)100, (int[])new int[]{0, 0, 0, 0}, (int)0, null, (float)0.0f);
        }
        hasInit = true;
    }

    public static void registerExtension(AbstractCraftableAnimalsExtension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Cannot register craftableAnimals extension null.");
        }
        if (extensions.contains(extension)) {
            throw new IllegalArgumentException("The craftableAnimals extension " + extension.getClass().getSimpleName() + " could not be registered. It already exists.");
        }
        extensions.add(extension);
        FMLLog.info((String)("The craftableAnimals extension " + extension.getClass().getSimpleName() + " was registered successfully."), (Object[])new Object[0]);
    }

    public static List<AbstractCraftableAnimalsExtension> getExtensions() {
        return Collections.unmodifiableList(extensions);
    }

    public static void addNameToItemMapping(ResourceLocation animal, ItemCraftableAnimal item) {
        nameToItemMap.put(animal, item);
    }

    public static ItemCraftableAnimal getItemFromName(ResourceLocation animal) {
        if (animal == null) {
            return null;
        }
        return nameToItemMap.get(animal);
    }

    public static ResourceLocation getAnimal(ItemStack stack) {
        return ((ICraftableAnimal)stack.func_77973_b()).getAnimal(stack);
    }

    public static int getType(ItemStack stack) {
        return ((ICraftableAnimal)stack.func_77973_b()).getType(stack);
    }

    public static EntityLiving[] createEntity(ItemStack stack, World world) {
        return ((ICraftableAnimal)stack.func_77973_b()).createEntity(stack, world);
    }

    public static EntityLiving[] spawn(ItemStack stack, EntityPlayer player, World world, double x, double y, double z, EnumFacing side) {
        return ((ICraftableAnimal)stack.func_77973_b()).spawn(stack, player, world, x, y, z, side);
    }

    public static ItemStack createItemCraftableAnimalStack(ItemStack stack) {
        return new ItemStack((Item)CraftableAnimalsRegistry.getItemFromName(((ItemCraftableAnimalBase)stack.func_77973_b()).getAnimal(stack)), stack.func_190916_E(), ((ItemCraftableAnimalBase)stack.func_77973_b()).getType(stack));
    }

    public static Map<Character, Integer> getProperties(ItemCraftableAnimal item) {
        if (!itemProperties.containsKey(item)) {
            itemProperties.put(item, new HashMap());
        }
        return itemProperties.get(item);
    }

    public static int getPropertiy(ItemCraftableAnimal item, char key) {
        Map<Character, Integer> map = CraftableAnimalsRegistry.getProperties(item);
        if (!map.containsKey(Character.valueOf(key))) {
            return -1;
        }
        return map.get(Character.valueOf(key));
    }

    public static Map<ResourceLocation, ItemCraftableAnimal> getNameToItemMap() {
        return Collections.unmodifiableMap(nameToItemMap);
    }

    static {
        CraftableAnimalsRegistry.init();
    }
}

