/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla;

import naruto1310.craftableAnimals.vanilla.CAFMLPlugin;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.math.RayTraceResult;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CATransformer
implements IClassTransformer {
    private String entityClass = null;
    private String trayTraceResultClass = null;
    private String itemStackClass = null;
    private String modelBaseClass = null;

    public byte[] transform(String name, String newName, byte[] bytes) {
        try {
            if (newName.contentEquals("net.minecraft.entity.Entity")) {
                this.entityClass = "L" + name.replace('.', '/') + ";";
                CAFMLPlugin.log.debug("Detected Entity class: " + this.entityClass);
                return this.transformEntity(bytes);
            }
            if (newName.contentEquals("net.minecraft.util.math.RayTraceResult")) {
                this.trayTraceResultClass = "L" + name.replace('.', '/') + ";";
                CAFMLPlugin.log.debug("Detected RayTraceResult class: " + this.trayTraceResultClass);
            }
            if (newName.contentEquals("net.minecraft.item.ItemStack")) {
                this.itemStackClass = "L" + name.replace('.', '/') + ";";
                CAFMLPlugin.log.debug("Detected ItemStack class: " + this.itemStackClass);
            }
            if (newName.contentEquals("net.minecraft.tileentity.MobSpawnerBaseLogic")) {
                return this.transformMobSpawnerBaseLogic(bytes, name);
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelBase")) {
                this.modelBaseClass = "L" + name.replace('.', '/') + ";";
                CAFMLPlugin.log.debug("Detected ModelBase class: " + this.modelBaseClass);
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelBiped")) {
                return this.transformModel(bytes, "ModelBiped");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelIronGolem")) {
                return this.transformModel(bytes, "ModelIronGolem");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelSpider")) {
                return this.transformModel(bytes, "ModelSpider");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelSquid")) {
                return this.transformModel(bytes, "ModelSquid");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelSlime")) {
                return this.transformModel(bytes, "ModelSlime");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelMagmaCube")) {
                return this.transformModel(bytes, "ModelMagmaCube");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelSnowMan")) {
                return this.transformModel(bytes, "ModelSnowMan");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelBlaze")) {
                return this.transformModel(bytes, "ModelBlaze");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelGhast")) {
                return this.transformModel(bytes, "ModelGhast");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelCreeper")) {
                return this.transformModel(this.transformModelCreeper(bytes), "ModelCreeper 2/2");
            }
            if (newName.contentEquals("net.minecraft.client.model.ModelQuadruped")) {
                return this.transformModel(bytes, "ModelQuadruped");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private byte[] transformEntity(byte[] bytes) throws Exception {
        CAFMLPlugin.log.debug("Starting to transform Entity.");
        if (this.trayTraceResultClass == null) {
            RayTraceResult.class.toString();
        }
        if (this.itemStackClass == null) {
            ItemStack.class.toString();
        }
        boolean hasTransformed = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (m.access != 1 || !m.desc.contentEquals("(" + this.trayTraceResultClass + ")" + this.itemStackClass)) continue;
            m.instructions.clear();
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "naruto1310/craftableAnimals/vanilla/CraftableAnimals", "getPickedEntityResult_entity", "(" + this.entityClass + this.trayTraceResultClass + ")" + this.itemStackClass, false));
            m.instructions.add((AbstractInsnNode)new InsnNode(176));
            hasTransformed = true;
            break;
        }
        if (hasTransformed) {
            CAFMLPlugin.log.debug("Finished transforming Entity successfully.");
        } else {
            CAFMLPlugin.log.info("Could not transform Entity.");
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformMobSpawnerBaseLogic(byte[] bytes, String oldName) {
        CAFMLPlugin.log.debug("Starting to transform MobSpawnerBaseLogic.");
        boolean hasTransformed = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.desc.contentEquals("()Z")) continue;
            m.instructions.clear();
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "naruto1310/craftableAnimals/vanilla/CraftableAnimals", "isActivated_MobSpawnerBaseLogic", "(L" + oldName.replace('.', '/') + ";)Z", false));
            m.instructions.add((AbstractInsnNode)new InsnNode(172));
            hasTransformed = true;
        }
        if (hasTransformed) {
            CAFMLPlugin.log.debug("Finished transforming MobSpawnerBaseLogic successfully.");
        } else {
            CAFMLPlugin.log.info("Could not transform MobSpawnerBaseLogic.");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformModel(byte[] bytes, String s) {
        CAFMLPlugin.log.debug("Starting to transform " + s + ".");
        if (this.entityClass == null) {
            Entity.class.toString();
        }
        if (this.modelBaseClass == null) {
            ModelBase.class.toString();
        }
        boolean hasTransformed = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (m.access != 1 || !m.desc.contentEquals("(" + this.entityClass + "FFFFFF)V")) continue;
            AbstractInsnNode insn = m.instructions.get(m.instructions.size() - 2);
            m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "naruto1310/craftableAnimals/vanilla/EntityArmorRenderer", "render", "(" + this.modelBaseClass + this.entityClass + ")V", false));
            hasTransformed = true;
            break;
        }
        if (hasTransformed) {
            CAFMLPlugin.log.debug("Finished transforming " + s + " successfully.");
        } else {
            CAFMLPlugin.log.info("Could not transform " + s + ".");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformModelCreeper(byte[] bytes) {
        CAFMLPlugin.log.debug("Starting to transform ModelCreeper 1/2.");
        if (this.entityClass == null) {
            Entity.class.toString();
        }
        boolean hasTransformed = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (m.access != 1 || !m.desc.contentEquals("(" + this.entityClass + "FFFFFF)V")) continue;
            int min = 4;
            int vin = 8;
            int fin = 4;
            for (int i = m.instructions.size() - 1; i >= 0; --i) {
                AbstractInsnNode insn = m.instructions.get(i);
                if (min > 0 && insn instanceof MethodInsnNode) {
                    m.instructions.remove(insn);
                    --min;
                }
                if (fin > 0 && insn instanceof FieldInsnNode) {
                    m.instructions.remove(insn);
                    --fin;
                }
                if (vin <= 0 || !(insn instanceof VarInsnNode)) continue;
                m.instructions.remove(insn);
                --vin;
            }
            hasTransformed = true;
            break;
        }
        if (hasTransformed) {
            CAFMLPlugin.log.debug("Finished transforming ModelCreeper 1/2 successfully.");
        } else {
            CAFMLPlugin.log.info("Could not transform ModelCreeper 1/2.");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

