/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import naruto1310.craftableAnimals.core.AbstractCraftableAnimalsExtension;
import naruto1310.craftableAnimals.core.ItemCraftableAnimal;
import naruto1310.craftableAnimals.core.SpawnEntity;
import naruto1310.craftableAnimals.vanilla.CAConfig;
import naruto1310.craftableAnimals.vanilla.CraftableAnimals;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class CAVanillaExtension
extends AbstractCraftableAnimalsExtension {
    protected static final List<ResourceLocation> handledEntitys = new ArrayList<ResourceLocation>();

    public static void registerEntity(ResourceLocation animal) {
        handledEntitys.add(animal);
    }

    @Override
    public boolean isHandler(ResourceLocation animal) {
        return handledEntitys.contains(animal);
    }

    @Override
    public EntityLiving modifyEntity(EntityLiving entity, World world, EntityPlayer player, int type) {
        if (entity instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)entity;
            horse.func_110235_q(0);
            horse.func_110235_q(type / 5 + type % 5 * 256);
            this.setAdult((EntityLiving)horse, true);
            return horse;
        }
        if (entity instanceof EntityOcelot) {
            EntityOcelot ocelot = (EntityOcelot)entity;
            ocelot.func_70912_b(type);
            ocelot.func_70903_f(false);
            return ocelot;
        }
        if (entity instanceof EntityPig) {
            EntityPig pig = (EntityPig)entity;
            if (type == 1) {
                pig.func_70900_e(true);
            }
            if (type == 16) {
                pig.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAITempt((EntityCreature)pig, 0.25, (Item)Items.field_151112_aM, false));
                this.setAdult((EntityLiving)pig, false);
                if (player != null) {
                    switch (player.func_70681_au().nextInt(3)) {
                        case 0: {
                            player.func_145747_a((ITextComponent)new TextComponentString("What the heck? Where am I?"));
                            break;
                        }
                        case 1: {
                            player.func_145747_a((ITextComponent)new TextComponentString("Hey, let's go fishing."));
                            break;
                        }
                        case 2: {
                            player.func_145747_a((ITextComponent)new TextComponentString("What's up?"));
                        }
                    }
                }
            }
            return pig;
        }
        if (entity instanceof EntityRabbit) {
            EntityRabbit rabbit = (EntityRabbit)entity;
            rabbit.func_175529_r(type != 6 ? type : 99);
            return rabbit;
        }
        if (entity instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)entity;
            sheep.func_175512_b(EnumDyeColor.values()[type % 16]);
            sheep.func_70893_e(type > 15);
            return sheep;
        }
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            villager.func_70938_b(type);
            return villager;
        }
        if (entity instanceof EntityLlama) {
            EntityLlama llama = (EntityLlama)entity;
            llama.func_190710_o(type);
            return llama;
        }
        if (entity instanceof EntityEnderman) {
            EntityEnderman enderman2 = (EntityEnderman)entity;
            if (type != 0) {
                enderman2.func_175490_a(Block.func_149729_e((int)(type >> 4)).func_176203_a(type % 16));
            }
            return enderman2;
        }
        if (entity instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)entity;
            if (type == 1) {
                wolf.func_70903_f(true);
                if (player != null) {
                    wolf.func_184754_b(player.func_110124_au());
                }
            }
            if (type == 2) {
                wolf.func_70916_h(true);
                if (player != null) {
                    wolf.func_70624_b((EntityLivingBase)player);
                }
            }
            return wolf;
        }
        if (entity instanceof EntitySlime) {
            try {
                EntitySlime slime = (EntitySlime)entity;
                boolean isMagmaCube = entity instanceof EntityMagmaCube;
                for (Method m : isMagmaCube ? slime.getClass().getSuperclass().getDeclaredMethods() : slime.getClass().getDeclaredMethods()) {
                    Class<?>[] params = m.getParameterTypes();
                    if (params.length != 2 || params[0] != Integer.TYPE || params[1] != Boolean.TYPE) continue;
                    m.setAccessible(true);
                    m.invoke((Object)slime, type == (isMagmaCube ? 3 : 4) ? CAConfig.giantSlimeSize : type + 1, true);
                }
                return slime;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)entity;
            if (type == 1) {
                NBTTagCompound nbt = new NBTTagCompound();
                creeper.func_70014_b(nbt);
                nbt.func_74757_a("powered", true);
                creeper.func_70037_a(nbt);
            }
            return creeper;
        }
        if (entity instanceof EntityPigZombie) {
            entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
            return entity;
        }
        if (entity instanceof EntityVex) {
            entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            return entity;
        }
        if (entity instanceof EntityVindicator) {
            entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151036_c));
            return entity;
        }
        if (entity instanceof EntityZombieVillager) {
            EntityZombieVillager zombie = (EntityZombieVillager)entity;
            zombie.func_190733_a(type);
            return zombie;
        }
        if (entity instanceof EntitySkeleton) {
            entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
            return entity;
        }
        return entity;
    }

    @Override
    public int getTypeFromEntity(EntityLiving entity) {
        if (entity instanceof EntityOcelot) {
            return ((EntityOcelot)entity).func_70913_u();
        }
        if (entity instanceof EntityPig) {
            return ((EntityPig)entity).func_70901_n() ? 1 : 0;
        }
        if (entity instanceof EntityRabbit) {
            return Math.min(((EntityRabbit)entity).func_175531_cl(), 6);
        }
        if (entity instanceof EntitySheep) {
            return ((EntitySheep)entity).func_175509_cj().ordinal();
        }
        if (entity instanceof EntityVillager) {
            return ((EntityVillager)entity).func_70946_n();
        }
        if (entity instanceof EntityLlama) {
            return ((EntityLlama)entity).func_190719_dM();
        }
        if (entity instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)entity;
            return wolf.func_70909_n() ? 1 : (wolf.func_70919_bu() ? 2 : 0);
        }
        if (entity instanceof EntityMagmaCube) {
            EntityMagmaCube magmaCube = (EntityMagmaCube)entity;
            return magmaCube.func_70809_q() < 3 ? magmaCube.func_70809_q() : 3;
        }
        if (entity instanceof EntitySlime) {
            EntitySlime slime = (EntitySlime)entity;
            return slime.func_70809_q() < 4 ? slime.func_70809_q() : 4;
        }
        if (entity instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n() ? 1 : 0;
        }
        if (entity instanceof EntityZombieVillager) {
            return ((EntityZombieVillager)entity).func_190736_dl();
        }
        return 0;
    }

    @Override
    public EntityLiving setAdult(EntityLiving entity, boolean adult) {
        if (entity instanceof EntityAgeable) {
            ((EntityAgeable)entity).func_70873_a(adult ? 6000 : -24000);
            return entity;
        }
        if (entity instanceof EntityZombie) {
            ((EntityZombie)entity).func_82227_f(!adult);
            return entity;
        }
        return null;
    }

    @Override
    public EntityLiving overwriteSpawn(ResourceLocation animal, World world, double x, double y, double z, EntityPlayer player, int type) {
        if (animal == CraftableAnimals.jockey.getAnimal()) {
            ItemCraftableAnimal[] spiders = new ItemCraftableAnimal[]{CraftableAnimals.spider, CraftableAnimals.cavespider, CraftableAnimals.chicken};
            ItemCraftableAnimal[] riders = new ItemCraftableAnimal[]{CraftableAnimals.skeleton, CraftableAnimals.skeleton_stray, CraftableAnimals.zombie, CraftableAnimals.zombie_husk, CraftableAnimals.zombiepig, CraftableAnimals.creeper};
            EntityLiving spider = SpawnEntity.spawn(spiders[type / 6].getAnimal(), world, x, y, z, player, 0);
            EntityLiving jockey = SpawnEntity.spawn(riders[type % 6].getAnimal(), world, x, y, z, player, 0);
            if (type >= 14 && type <= 16) {
                this.setAdult(jockey, false);
            }
            jockey.func_184220_m((Entity)spider);
            return spider;
        }
        return null;
    }
}

