/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBlaze;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelCow;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.model.ModelEnderman;
import net.minecraft.client.model.ModelGhast;
import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.model.ModelMagmaCube;
import net.minecraft.client.model.ModelPig;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSheep2;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.model.ModelSnowMan;
import net.minecraft.client.model.ModelSpider;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EntityArmorRenderer {
    private static EntityArmorRenderer instance = new EntityArmorRenderer();
    private Map<ModelBase, ModelRenderer> helmets = new HashMap<ModelBase, ModelRenderer>();
    private Map<ModelBase, ModelRenderer> chests0 = new HashMap<ModelBase, ModelRenderer>();
    private Map<ModelBase, ModelRenderer> chests1 = new HashMap<ModelBase, ModelRenderer>();
    private Map<ModelBase, ModelRenderer> chests2 = new HashMap<ModelBase, ModelRenderer>();
    private Map<ModelBase, ModelRenderer> alegs = new HashMap<ModelBase, ModelRenderer>();
    private Map<ModelBase, ModelRenderer> clegs = new HashMap<ModelBase, ModelRenderer>();
    private Field blazeHead = null;
    private Field blazeSticks = null;
    private Field ghastBody = null;
    private Field ghastTentacles = null;
    private Field squidBody = null;
    private Field squidTentacles = null;
    private Field slimeBodys = null;
    private Field magmaCubeBodys = null;
    private ModelRenderer[] ghastLegs = null;
    private ResourceLocation textureCreeper = new ResourceLocation("textures/entity/creeper/creeper.png");
    private ResourceLocation texturePig = new ResourceLocation("textures/entity/pig/pig.png");
    private ResourceLocation textureSlime = new ResourceLocation("textures/entity/slime/slime.png");
    private boolean setColor = true;
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();
    public static String[] bipedArmorFilenamePrefix = new String[]{"leather", "chainmail", "iron", "diamond", "gold"};

    public static void render(ModelBase model, Entity entity) {
        instance.renderArmor(model, entity);
    }

    private void renderArmor(ModelBase model, Entity entity) {
        if (!(entity instanceof EntityLiving) || entity instanceof EntityArmorStand) {
            return;
        }
        boolean bl = this.setColor = ((EntityLiving)entity).field_70737_aN == 0;
        if (model instanceof ModelQuadruped) {
            this.renderQuadruped(model, entity);
        } else if (model instanceof ModelCreeper) {
            this.renderCreeper(model, entity);
        } else if (model instanceof ModelSquid) {
            this.renderSquid(model, entity);
        } else if (model instanceof ModelBlaze) {
            this.renderBlaze(model, entity);
        } else if (model instanceof ModelEnderman) {
            this.renderEnderman(model, entity);
        } else if (model instanceof ModelGhast) {
            this.renderGhast(model, entity);
        } else if (model instanceof ModelSpider) {
            this.renderSpider(model, entity);
        } else if (model instanceof ModelSlime) {
            this.renderSlime(model, entity);
        } else if (model instanceof ModelMagmaCube) {
            this.renderMagmaCube(model, entity);
        } else if (model instanceof ModelSnowMan) {
            this.renderSnowMan(model, entity);
        } else if (model instanceof ModelIronGolem) {
            this.renderIronGolem(model, entity);
        }
    }

    private void renderQuadruped(ModelBase model, Entity entity) {
        ModelRenderer aleg;
        boolean c = model.field_78091_s;
        ModelQuadruped q = (ModelQuadruped)model;
        if (model instanceof ModelSheep2) {
            if (c) {
                GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.25f);
            }
            this.render(this.setupHelmet(model, q.field_78150_a, -6.0f, -6.1f), entity, 5, 1.0f);
            if (c) {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.25f);
            }
        }
        if (model instanceof ModelCow) {
            if (c) {
                GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.375f);
            }
            this.render(this.setupHelmet(model, q.field_78150_a, -6.0f, -7.0f), entity, 5, 1.0f);
            if (c) {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.375f);
            }
        }
        if (model instanceof ModelPig) {
            if (model.field_78091_s) {
                GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.25f);
            }
            this.render(this.setupHelmet(model, q.field_78150_a, -6.0f, -8.5f), entity, 5, 1.0f);
            if (model.field_78091_s) {
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)-0.25f);
            }
        }
        if (!this.hasArmor(entity, 2)) {
            return;
        }
        if (c) {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glTranslatef((float)0.0f, (float)1.5f, (float)0.0f);
        }
        if (model instanceof ModelCow) {
            this.render(q.field_78149_c, entity, 2, 1.0f);
            this.render(q.field_78146_d, entity, 2, 1.0f);
            this.render(q.field_78147_e, entity, 2, 1.0f);
            this.render(q.field_78144_f, entity, 2, 1.0f);
        }
        if (model instanceof ModelPig && this.hasArmor(entity, 2)) {
            ModelRenderer cleg;
            aleg = this.alegs.get(model);
            if (aleg == null) {
                aleg = new ModelRenderer(model, 0, 16);
                aleg.func_78790_a(-2.0f, -6.0f, -2.0f, 4, 12, 4, 0.0f);
                this.alegs.put(model, aleg);
            }
            if ((cleg = this.clegs.get(model)) == null) {
                cleg = new ModelRenderer(model);
                cleg.field_78804_l.add(new ModelCustomBox(cleg, 0, 16, -2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f));
                this.clegs.put(model, cleg);
            }
            for (int i = 0; i < 4; ++i) {
                ModelRenderer leg = i == 0 ? q.field_78149_c : (i == 1 ? q.field_78146_d : (i == 2 ? q.field_78147_e : q.field_78144_f));
                aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                cleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                cleg.field_78795_f = aleg.field_78795_f = leg.field_78795_f;
                cleg.field_78796_g = aleg.field_78796_g = leg.field_78796_g;
                cleg.field_78808_h = aleg.field_78808_h = leg.field_78808_h;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texturePig);
                if (this.setColor) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                cleg.func_78785_a(0.0625f);
                this.render(aleg, entity, 2, 1.0f);
            }
        }
        if (model instanceof ModelSheep2 && this.hasArmor(entity, 2)) {
            aleg = this.alegs.get(model);
            if (aleg == null) {
                aleg = new ModelRenderer(model, 0, 16);
                aleg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
                this.alegs.put(model, aleg);
            }
            for (int i = 0; i < 4; ++i) {
                ModelRenderer leg = i == 0 ? q.field_78149_c : (i == 1 ? q.field_78146_d : (i == 2 ? q.field_78147_e : q.field_78144_f));
                aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                aleg.field_78795_f = leg.field_78795_f;
                aleg.field_78796_g = leg.field_78796_g;
                aleg.field_78808_h = leg.field_78808_h;
                if (this.setColor) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                this.render(aleg, entity, 2, 1.0f);
            }
        }
        if (c) {
            GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        }
    }

    private void renderCreeper(ModelBase model, Entity entity) {
        ModelCreeper m = (ModelCreeper)model;
        if (this.hasArmor(entity, 5)) {
            this.render(this.setupHelmet(model, ((ModelCreeper)model).field_78135_a, -8.5f, -4.5f), entity, 5, 1.0f);
        }
        if (this.hasArmor(entity, 4)) {
            this.render(((ModelCreeper)model).field_78134_c, entity, 4, 1.1f);
        }
        if (this.hasArmor(entity, 2)) {
            ModelRenderer cleg;
            ModelRenderer aleg = this.alegs.get(model);
            if (aleg == null) {
                aleg = new ModelRenderer(model, 0, 16);
                aleg.func_78790_a(-2.0f, -6.0f, -2.0f, 4, 12, 4, 0.0f);
                this.alegs.put(model, aleg);
            }
            if ((cleg = this.clegs.get(model)) == null) {
                cleg = new ModelRenderer(model);
                cleg.field_78804_l.add(new ModelCustomBox(cleg, 0, 16, -2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f));
                this.clegs.put(model, cleg);
            }
            for (int i = 0; i < 4; ++i) {
                ModelRenderer leg = i == 0 ? m.field_78131_d : (i == 1 ? m.field_78132_e : (i == 2 ? m.field_78129_f : m.field_78130_g));
                aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                cleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                cleg.field_78795_f = aleg.field_78795_f = leg.field_78795_f;
                cleg.field_78796_g = aleg.field_78796_g = leg.field_78796_g;
                cleg.field_78808_h = aleg.field_78808_h = leg.field_78808_h;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureCreeper);
                if (this.setColor) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                cleg.func_78785_a(0.0625f);
                this.render(aleg, entity, 2, 1.0f);
            }
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureCreeper);
            m.field_78131_d.func_78785_a(0.0625f);
            m.field_78132_e.func_78785_a(0.0625f);
            m.field_78129_f.func_78785_a(0.0625f);
            m.field_78130_g.func_78785_a(0.0625f);
        }
    }

    private void renderSquid(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            try {
                this.render(this.setupHelmet(model, (ModelRenderer)this.squidBody.get(model), -8.5f, -4.5f), entity, 5, 1.5f);
            }
            catch (Exception e) {
                if (this.squidBody == null) {
                    for (Field f : ModelSquid.class.getDeclaredFields()) {
                        if (f.getType() != ModelRenderer.class) continue;
                        f.setAccessible(true);
                        this.squidBody = f;
                    }
                }
                e.printStackTrace();
            }
        }
        if (this.hasArmor(entity, 2)) {
            try {
                ModelRenderer[] tentacles = (ModelRenderer[])this.squidTentacles.get(model);
                ModelRenderer aleg = this.alegs.get(model);
                if (aleg == null) {
                    aleg = new ModelRenderer(model, 0, 16);
                    aleg.func_78790_a(-2.0f, 7.0f, -2.0f, 4, 12, 4, 0.0f);
                    this.alegs.put(model, aleg);
                }
                for (int i = 0; i < 8; ++i) {
                    ModelRenderer leg = tentacles[i];
                    aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                    aleg.field_78795_f = leg.field_78795_f;
                    aleg.field_78796_g = leg.field_78796_g;
                    aleg.field_78808_h = leg.field_78808_h;
                    this.render(aleg, entity, 2, 1.0f);
                }
            }
            catch (Exception e) {
                for (Field f : ModelSquid.class.getDeclaredFields()) {
                    if (f.getType() != ModelRenderer[].class) continue;
                    f.setAccessible(true);
                    this.squidTentacles = f;
                    break;
                }
            }
        }
    }

    private void renderBlaze(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            try {
                this.render(this.setupHelmet(model, (ModelRenderer)this.blazeHead.get(model), -6.0f, -4.5f), entity, 5, 1.0f);
            }
            catch (Exception e) {
                if (this.blazeHead == null) {
                    for (Field f : ModelBlaze.class.getDeclaredFields()) {
                        if (f.getType() != ModelRenderer.class) continue;
                        f.setAccessible(true);
                        this.blazeHead = f;
                    }
                }
                e.printStackTrace();
            }
        }
        if (this.hasArmor(entity, 2)) {
            try {
                ModelRenderer[] blazeSticksModel = (ModelRenderer[])this.blazeSticks.get(model);
                ModelRenderer aleg = this.alegs.get(model);
                if (aleg == null) {
                    aleg = new ModelRenderer(model, 0, 16);
                    aleg.func_78790_a(-1.0f, -6.0f, -1.0f, 4, 12, 4, 0.0f);
                    this.alegs.put(model, aleg);
                }
                for (int i = 8; i < 12; ++i) {
                    ModelRenderer leg = blazeSticksModel[i];
                    aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                    aleg.field_78795_f = leg.field_78795_f;
                    aleg.field_78796_g = leg.field_78796_g;
                    aleg.field_78808_h = leg.field_78808_h;
                    this.render(aleg, entity, 2, 1.0f);
                }
            }
            catch (Exception e) {
                for (Field f : ModelBlaze.class.getDeclaredFields()) {
                    if (f.getType() != ModelRenderer[].class) continue;
                    f.setAccessible(true);
                    this.blazeSticks = f;
                    break;
                }
            }
        }
    }

    private void renderEnderman(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            this.render(this.setupHelmet(model, ((ModelEnderman)model).field_78116_c, -8.5f, -4.5f), entity, 5, 1.0f);
        }
        if (this.hasArmor(entity, 4)) {
            ModelRenderer chest = this.chests0.get(model);
            if (chest == null) {
                chest = new ModelRenderer(model, 16, 16);
                chest.func_78790_a(-4.0f, 2.0f, -2.0f, 8, 12, 4, 0.0f);
                this.chests0.put(model, chest);
            }
            ModelRenderer m = ((ModelEnderman)model).field_78115_e;
            chest.func_78793_a(m.field_78800_c, m.field_78797_d, m.field_78798_e);
            chest.field_78795_f = m.field_78795_f;
            chest.field_78796_g = m.field_78796_g + (float)Math.toRadians(180.0);
            chest.field_78808_h = m.field_78808_h;
            this.render(chest, entity, 4, 1.1f);
            ModelRenderer armL = this.chests1.get(model);
            if (armL == null) {
                armL = new ModelRenderer(model, 40, 16);
                armL.func_78790_a(-2.5f, -2.5f, -2.0f, 4, 12, 4, 0.0f);
                this.chests1.put(model, armL);
            }
            m = ((ModelEnderman)model).field_178724_i;
            armL.func_78793_a(m.field_78800_c, m.field_78797_d, m.field_78798_e);
            armL.field_78795_f = m.field_78795_f;
            armL.field_78796_g = m.field_78796_g;
            armL.field_78808_h = m.field_78808_h;
            this.render(armL, entity, 4, 1.0f);
            ModelRenderer armR = this.chests2.get(model);
            if (armR == null) {
                armR = new ModelRenderer(model, 40, 16);
                armR.func_78790_a(-1.5f, -2.5f, -2.0f, 4, 12, 4, 0.0f);
                this.chests2.put(model, armR);
            }
            m = ((ModelEnderman)model).field_178723_h;
            armR.func_78793_a(m.field_78800_c, m.field_78797_d, m.field_78798_e);
            armR.field_78795_f = m.field_78795_f;
            armR.field_78796_g = m.field_78796_g;
            armR.field_78808_h = m.field_78808_h;
            this.render(armR, entity, 4, 1.0f);
        }
        if (this.hasArmor(entity, 2)) {
            ModelEnderman m = (ModelEnderman)model;
            ModelRenderer aleg = this.alegs.get(model);
            if (aleg == null) {
                aleg = new ModelRenderer(model, 0, 16);
                aleg.func_78790_a(-2.0f, 20.0f, -2.0f, 4, 12, 4, 0.0f);
                this.alegs.put(model, aleg);
            }
            for (int i = 0; i < 2; ++i) {
                ModelRenderer leg = i == 0 ? m.field_178722_k : m.field_178721_j;
                aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                aleg.field_78795_f = leg.field_78795_f;
                aleg.field_78796_g = leg.field_78796_g;
                aleg.field_78808_h = leg.field_78808_h;
                this.render(aleg, entity, 2, 1.0f);
            }
        }
    }

    private void renderGhast(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            try {
                GL11.glScalef((float)1.0f, (float)0.8f, (float)1.0f);
                this.render(this.setupHelmet(model, (ModelRenderer)this.ghastBody.get(model), -3.7f, -4.5f), entity, 5, 2.0f);
                GL11.glScalef((float)1.0f, (float)1.25f, (float)1.0f);
            }
            catch (Exception e) {
                if (this.ghastBody == null) {
                    for (Field f : ModelGhast.class.getDeclaredFields()) {
                        if (f.getType() != ModelRenderer.class) continue;
                        f.setAccessible(true);
                        this.ghastBody = f;
                    }
                }
                e.printStackTrace();
            }
        }
        if (this.hasArmor(entity, 2)) {
            try {
                ModelRenderer[] ghastTentaclesModel = (ModelRenderer[])this.ghastTentacles.get(model);
                if (this.ghastLegs == null) {
                    this.ghastLegs = new ModelRenderer[9];
                    Random random = new Random(1660L);
                    for (int i = 0; i < 9; ++i) {
                        this.ghastLegs[i] = new ModelRenderer(model, 0, 16);
                        this.ghastLegs[i].func_78790_a(-2.0f, (float)(random.nextInt(7) - 4), -1.0f, 4, 12, 4, 0.0f);
                    }
                }
                GL11.glTranslatef((float)0.0f, (float)0.7f, (float)0.0f);
                for (int i = 0; i < 9; ++i) {
                    ModelRenderer leg = ghastTentaclesModel[i];
                    this.ghastLegs[i].func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                    this.ghastLegs[i].field_78795_f = leg.field_78795_f;
                    this.ghastLegs[i].field_78796_g = leg.field_78796_g;
                    this.ghastLegs[i].field_78808_h = leg.field_78808_h;
                    this.render(this.ghastLegs[i], entity, 2, 1.0f);
                }
            }
            catch (Exception e) {
                for (Field f : ModelGhast.class.getDeclaredFields()) {
                    if (f.getType() != ModelRenderer[].class) continue;
                    f.setAccessible(true);
                    this.ghastTentacles = f;
                    break;
                }
            }
        }
    }

    private void renderSpider(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            this.render(this.setupHelmet(model, ((ModelSpider)model).field_78209_a, -6.0f, -8.5f), entity, 5, 1.0f);
        }
        if (this.hasArmor(entity, 2)) {
            ModelSpider m = (ModelSpider)model;
            ModelRenderer aleg = this.alegs.get(model);
            if (aleg == null) {
                aleg = new ModelRenderer(model, 0, 16);
                aleg.func_78790_a(-2.0f, 4.0f, -2.0f, 4, 12, 4, 0.0f);
                this.alegs.put(model, aleg);
            }
            ModelRenderer[] legs = new ModelRenderer[]{m.field_78205_d, m.field_78206_e, m.field_78203_f, m.field_78204_g, m.field_78212_h, m.field_78213_i, m.field_78210_j, m.field_78211_k};
            for (int i = 0; i < 8; ++i) {
                ModelRenderer leg = legs[i];
                aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                aleg.field_78795_f = leg.field_78796_g;
                aleg.field_78796_g = leg.field_78795_f;
                aleg.field_78808_h = -leg.field_78808_h;
                if (i % 2 == 1) {
                    aleg.field_78795_f *= -1.0f;
                }
                if (i / 2 == 1) {
                    aleg.field_78808_h = aleg.field_78808_h + (i % 2 == 0 ? 0.4f : -0.4f);
                }
                if (i == 4 || i == 6) {
                    aleg.field_78808_h = leg.field_78808_h + (float)Math.toRadians(90.0);
                }
                if (i == 5 || i == 7) {
                    aleg.field_78808_h = leg.field_78808_h - (float)Math.toRadians(90.0);
                }
                this.render(aleg, entity, 2, 1.0f);
            }
        }
    }

    private void renderSlime(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            try {
                this.render(this.setupHelmet(model, (ModelRenderer)this.slimeBodys.get(model), 14.0f, -4.5f), entity, 5, 1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureSlime);
            }
            catch (Exception e) {
                if (this.slimeBodys == null) {
                    Field f = ModelSlime.class.getDeclaredFields()[0];
                    f.setAccessible(true);
                    this.slimeBodys = f;
                }
                e.printStackTrace();
            }
        }
    }

    private void renderMagmaCube(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            try {
                this.render(this.setupHelmet(model, ((ModelRenderer[])this.magmaCubeBodys.get(model))[0], 14.0f, -4.5f), entity, 5, 1.0f);
            }
            catch (Exception e) {
                if (this.magmaCubeBodys == null) {
                    for (Field f : ModelMagmaCube.class.getDeclaredFields()) {
                        if (f.getType() != ModelRenderer[].class) continue;
                        f.setAccessible(true);
                        this.magmaCubeBodys = f;
                    }
                }
                e.printStackTrace();
            }
        }
    }

    private void renderSnowMan(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            this.render(this.setupHelmet(model, ((ModelSnowMan)model).field_78195_c, -10.0f, -4.7f), entity, 5, 1.3f);
        }
    }

    private void renderIronGolem(ModelBase model, Entity entity) {
        if (this.hasArmor(entity, 5)) {
            this.render(this.setupHelmet(model, ((ModelIronGolem)model).field_78178_a, -12.1f, -6.0f), entity, 5, 1.0f);
        }
        if (this.hasArmor(entity, 2)) {
            ModelIronGolem m = (ModelIronGolem)model;
            ModelRenderer aleg = this.alegs.get(model);
            if (aleg == null) {
                aleg = new ModelRenderer(model, 0, 16);
                aleg.func_78790_a(-2.0f, 0.0f, -6.0f, 4, 12, 4, 0.0f);
                this.alegs.put(model, aleg);
            }
            for (int i = 0; i < 2; ++i) {
                ModelRenderer leg = i == 0 ? m.field_78175_e : m.field_78173_f;
                aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                aleg.field_78795_f = leg.field_78795_f;
                aleg.field_78796_g = leg.field_78796_g;
                aleg.field_78808_h = leg.field_78808_h;
                this.render(aleg, entity, 2, 1.0f);
            }
        }
    }

    private ModelRenderer setupHelmet(ModelBase model, ModelRenderer head, float y, float z) {
        ModelRenderer helmet = this.helmets.get(model);
        if (helmet == null) {
            helmet = new ModelRenderer(model, 0, 0).func_78787_b(72, 36);
            helmet.func_78790_a(-4.5f, y, z, 9, 9, 9, 0.0f);
            this.helmets.put(model, helmet);
        }
        helmet.func_78793_a(head.field_78800_c, head.field_78797_d, head.field_78798_e);
        helmet.field_78795_f = head.field_78795_f;
        helmet.field_78796_g = head.field_78796_g;
        helmet.field_78808_h = head.field_78808_h;
        return helmet;
    }

    private boolean hasArmor(Entity entity, int slot) {
        return ((EntityLiving)entity).func_184582_a(EntityEquipmentSlot.values()[slot]) != null;
    }

    private void render(ModelRenderer model, Entity entity, int slot, float scale) {
        ItemStack stack = ((EntityLiving)entity).func_184582_a(EntityEquipmentSlot.values()[slot]);
        if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(EntityArmorRenderer.getArmorResource(entity, stack, EntityEquipmentSlot.values()[slot]));
        if (this.setColor) {
            int c = ((ItemArmor)stack.func_77973_b()).func_82814_b(stack);
            GL11.glColor3f((float)((float)(c >> 16 & 0xFF) / 255.0f), (float)((float)(c >> 8 & 0xFF) / 255.0f), (float)((float)(c & 0xFF) / 255.0f));
        }
        if (scale != 1.0f) {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        model.func_78785_a(0.0625f);
        if (scale != 1.0f) {
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        }
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot) {
        String s1 = String.format("textures/models/armor/%s_layer_%d.png", ((ItemArmor)stack.func_77973_b()).func_82812_d().func_179242_c(), 1);
        ResourceLocation resourcelocation = field_177191_j.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EntityEquipmentSlot)slot, null));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    private class ModelCustomBox
    extends ModelBox {
        private Field quadListField;
        private TexturedQuad[] quadList;

        public ModelCustomBox(ModelRenderer par1ModelRenderer, int par2, int par3, float par4, float par5, float par6, int par7, int par8, int par9, float par10) {
            super(par1ModelRenderer, par2, par3, par4, par5, par6, par7, par8, par9, par10);
        }

        public void func_178780_a(VertexBuffer renderer, float par2) {
            TexturedQuad[] ql = this.getQuadList();
            ql[2].func_178765_a(renderer, par2);
        }

        private TexturedQuad[] getQuadList() {
            if (this.quadList != null) {
                return this.quadList;
            }
            try {
                if (this.quadListField == null) {
                    for (Field f : ModelBox.class.getDeclaredFields()) {
                        if (f.getType() != TexturedQuad[].class) continue;
                        f.setAccessible(true);
                        this.quadListField = f;
                    }
                }
                this.quadList = (TexturedQuad[])this.quadListField.get((Object)this);
                return this.quadList;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

